/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.positions.Positions;

public interface Geometry<P extends Positions> {
    public Type type();

    public P positions();

    public int size();

    public static enum Type {
        POINT("Point"),
        MULTI_POINT("MultiPoint"),
        LINE_STRING("LineString"),
        LINEAR_RING("LineString"),
        MULTI_LINE_STRING("MultiLineString"),
        POLYGON("Polygon"),
        MULTI_POLYGON("MultiPolygon"),
        GEOMETRY_COLLECTION("GeometryCollection");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Type forValue(String value) {
            for (Type type : Type.values()) {
                if (!type.getValue().equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Cannot build a geometry for type: " + value);
        }
    }
}

