/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Objects;

public class Feature {
    private final Geometry<?> geometry;
    private final ImmutableMap<String, JsonElement> properties;
    private final Optional<String> id;

    public Feature(Geometry<?> geometry, ImmutableMap<String, JsonElement> properties, Optional<String> id) {
        this.geometry = geometry;
        this.properties = properties;
        this.id = id;
    }

    public static Feature of(Geometry<?> geometry) {
        return new Feature(geometry, (ImmutableMap<String, JsonElement>)ImmutableMap.of(), (Optional<String>)Optional.absent());
    }

    public Geometry<?> geometry() {
        return this.geometry;
    }

    public ImmutableMap<String, JsonElement> properties() {
        return this.properties;
    }

    public Optional<String> id() {
        return this.id;
    }

    public Feature withId(String id) {
        return new Feature(this.geometry, this.properties, (Optional<String>)Optional.of((Object)id));
    }

    public Feature withProperties(ImmutableMap<String, JsonElement> properties) {
        return new Feature(this.geometry, properties, this.id);
    }

    public Feature withProperty(String name, JsonElement value) {
        return new Feature(this.geometry, (ImmutableMap<String, JsonElement>)ImmutableMap.builder().putAll(this.properties).put((Object)name, (Object)value).build(), this.id);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.id, this.geometry, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.properties, other.properties) && Objects.equals(this.geometry, other.geometry);
    }
}

