/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double lon;
    private final double lat;
    private final double alt;

    private Coordinates(double lon, double lat, double alt) {
        this.lon = lon;
        this.lat = lat;
        this.alt = alt;
    }

    public static Coordinates of(double lon, double lat) {
        return new Coordinates(lon, lat, Double.NaN);
    }

    public static Coordinates of(double lon, double lat, double alt) {
        return new Coordinates(lon, lat, alt);
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getAlt() {
        return this.alt;
    }

    public Coordinates withLon(double lon) {
        return Coordinates.of(lon, this.lat);
    }

    public Coordinates withLat(double lat) {
        return Coordinates.of(this.lon, lat);
    }

    public Coordinates withAlt(double alt) {
        return Coordinates.of(this.lon, this.lat, alt);
    }

    public int hashCode() {
        return Objects.hash(Coordinates.class, this.lon, this.lat, this.alt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        return Objects.equals(this.lon, other.lon) && Objects.equals(this.lat, other.lat) && Objects.equals(this.alt, other.alt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lon", this.lon).add("lat", this.lat).add("alt", this.alt).toString();
    }
}

