/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.Positions;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractGeometry<P extends Positions>
implements Geometry<P>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final P positions;

    protected AbstractGeometry(P positions) {
        Preconditions.checkArgument((positions != null ? 1 : 0) != 0);
        this.positions = positions;
    }

    public static <P extends Positions> Function<AbstractGeometry<P>, P> positionsFn(Class<P> positionsClass) {
        return new Function<AbstractGeometry<P>, P>(){

            public P apply(AbstractGeometry<P> input) {
                return input.positions();
            }
        };
    }

    @Override
    public P positions() {
        return this.positions;
    }

    @Override
    public int size() {
        return this.positions.size();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.positions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeometry other = (AbstractGeometry)obj;
        return Objects.equals(this.positions, other.positions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positions", this.positions).toString();
    }
}

