/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.gson;

import com.github.filosganga.geogson.gson.FeatureAdapter;
import com.github.filosganga.geogson.gson.FeatureCollectionAdapter;
import com.github.filosganga.geogson.gson.PositionsAdapter;
import com.github.filosganga.geogson.model.Feature;
import com.github.filosganga.geogson.model.FeatureCollection;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.GeometryCollection;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.LinearRing;
import com.github.filosganga.geogson.model.MultiLineString;
import com.github.filosganga.geogson.model.MultiPoint;
import com.github.filosganga.geogson.model.MultiPolygon;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public class GeometryAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (Geometry.class.isAssignableFrom(type.getRawType())) {
            return new GeometryAdapter(gson);
        }
        if (Positions.class.isAssignableFrom(type.getRawType())) {
            return new PositionsAdapter();
        }
        if (Feature.class.isAssignableFrom(type.getRawType())) {
            return new FeatureAdapter(gson);
        }
        if (FeatureCollection.class.isAssignableFrom(type.getRawType())) {
            return new FeatureCollectionAdapter(gson);
        }
        return null;
    }

    private static class GeometryAdapter
    extends TypeAdapter<Geometry> {
        private final Gson gson;

        private GeometryAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, Geometry value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.beginObject();
                out.name("type").value(value.type().getValue());
                if (value.type() == Geometry.Type.GEOMETRY_COLLECTION) {
                    out.name("geometries");
                    out.beginArray();
                    GeometryCollection geometries = (GeometryCollection)value;
                    for (Geometry<?> geometry : geometries.getGeometries()) {
                        this.gson.getAdapter(Geometry.class).write(out, geometry);
                    }
                    out.endArray();
                } else {
                    out.name("coordinates");
                    this.gson.getAdapter(Positions.class).write(out, value.positions());
                }
                out.endObject();
            }
        }

        public Geometry<?> read(JsonReader in) throws IOException {
            Geometry<?> geometry = null;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
                in.beginObject();
                String type = null;
                Positions positions = null;
                Geometry<?> geometries = null;
                while (in.hasNext()) {
                    String name = in.nextName();
                    if ("type".equals(name)) {
                        type = in.nextString();
                        continue;
                    }
                    if ("coordinates".equals(name)) {
                        positions = this.readPosition(in);
                        continue;
                    }
                    if ("geometries".equals(name)) {
                        geometries = this.readGeometries(in);
                        continue;
                    }
                    in.skipValue();
                }
                geometry = this.buildGeometry(type, positions, geometries);
                in.endObject();
            } else {
                throw new IllegalArgumentException("The given json is not a valid Geometry: " + in.peek());
            }
            return geometry;
        }

        private Positions readPosition(JsonReader in) throws IOException {
            return (Positions)this.gson.getAdapter(Positions.class).read(in);
        }

        private Geometry<?> readGeometries(JsonReader in) throws IOException {
            Geometry<?> parsed;
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                parsed = null;
            } else if (peek == JsonToken.BEGIN_ARRAY) {
                parsed = this.parseGeometries(in);
            } else {
                throw new IllegalArgumentException("The json must be an array or null: " + in.peek());
            }
            return parsed;
        }

        private Geometry<?> parseGeometries(JsonReader in) throws IOException {
            Optional parsed = Optional.absent();
            if (in.peek() != JsonToken.BEGIN_ARRAY) {
                throw new IllegalArgumentException("The given json is not a valid GeometryCollection");
            }
            in.beginArray();
            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                ArrayList geometries = new ArrayList();
                while (in.hasNext()) {
                    Geometry geometry = (Geometry)this.gson.getAdapter(Geometry.class).read(in);
                    geometries.add(geometry);
                }
                parsed = Optional.of((Object)GeometryCollection.of(geometries));
            }
            in.endArray();
            return (Geometry)parsed.orNull();
        }

        private Geometry<?> buildGeometry(String type, Positions positions, Geometry<?> geometries) {
            switch (Geometry.Type.forValue(type)) {
                case GEOMETRY_COLLECTION: {
                    return geometries;
                }
                case MULTI_POLYGON: {
                    return new MultiPolygon((MultiDimensionalPositions)positions);
                }
                case POLYGON: {
                    return new Polygon((AreaPositions)positions);
                }
                case MULTI_LINE_STRING: {
                    return new MultiLineString((AreaPositions)positions);
                }
                case LINEAR_RING: 
                case LINE_STRING: {
                    return ((LinearPositions)positions).isClosed() ? new LinearRing((LinearPositions)positions) : new LineString((LinearPositions)positions);
                }
                case MULTI_POINT: {
                    return new MultiPoint((LinearPositions)positions);
                }
                case POINT: {
                    return Point.from(((SinglePosition)positions).coordinates());
                }
            }
            throw new IllegalArgumentException("Cannot build a geometry for type: " + type);
        }
    }
}

