/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.gml;

import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class GmlGraphFormatter
implements GraphFormatter {
    @Override
    public String format(String graphName, Collection<Node<?>> nodes, Collection<Edge> edges) {
        StringBuilder result = new StringBuilder();
        result.append("graph [\n");
        for (Node<?> node : nodes) {
            result.append("node [\n");
            result.append("id \"").append(node.getNodeId()).append("\"\n");
            if (StringUtils.isNotBlank((CharSequence)node.getNodeName())) {
                result.append(node.getNodeName()).append("\n");
            }
            result.append("]\n\n");
        }
        for (Edge edge : edges) {
            result.append("edge [\n");
            result.append("source \"").append(edge.getFromNodeId()).append("\"\n");
            result.append("target \"").append(edge.getToNodeId()).append("\"\n");
            if (StringUtils.isNotBlank((CharSequence)edge.getName())) {
                result.append(edge.getName()).append("\n");
            }
            result.append("]\n\n");
        }
        result.append("]");
        return result.toString();
    }
}

