/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.converter;

import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.renderer.CukedoctorFeatureRenderer;
import com.github.cukedoctor.renderer.CukedoctorSummaryRenderer;
import com.github.cukedoctor.spi.FeatureRenderer;
import com.github.cukedoctor.spi.SummaryRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.FileUtil;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class CukedoctorConverterImpl
implements CukedoctorConverter {
    private List<Feature> features;
    private DocumentAttributes documentAttributes;
    private String filename;
    private CukedoctorDocumentBuilder docBuilder;
    private I18nLoader i18n;
    private SummaryRenderer summaryRenderer;
    private FeatureRenderer featureRenderer;
    private CukedoctorConfig cukedoctorConfig;

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs) {
        this(features, attrs, new CukedoctorConfig());
    }

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs, CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
        this.features = features;
        Collections.sort(this.features);
        this.documentAttributes = attrs;
        this.docBuilder = CukedoctorDocumentBuilder.Factory.newInstance();
        this.i18n = I18nLoader.newInstance(features);
        this.loadRenderers();
    }

    private void loadRenderers() {
        ServiceLoader<SummaryRenderer> summaryRenderers = ServiceLoader.load(SummaryRenderer.class);
        ServiceLoader<FeatureRenderer> featureRenderers = ServiceLoader.load(FeatureRenderer.class);
        this.summaryRenderer = summaryRenderers.iterator().hasNext() ? summaryRenderers.iterator().next() : new CukedoctorSummaryRenderer();
        this.summaryRenderer.setDocumentBuilder(CukedoctorDocumentBuilder.Factory.newInstance());
        this.summaryRenderer.setI18n(this.i18n);
        this.featureRenderer = featureRenderers.iterator().hasNext() ? featureRenderers.iterator().next() : new CukedoctorFeatureRenderer();
        this.featureRenderer.setDocumentBuilder(CukedoctorDocumentBuilder.Factory.newInstance());
        this.featureRenderer.setI18n(this.i18n);
        this.featureRenderer.setDocumentAttributes(this.documentAttributes);
    }

    @Override
    public DocumentAttributes getDocumentAttributes() {
        return this.documentAttributes;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getDocumentation() {
        return this.docBuilder.toString();
    }

    @Override
    public synchronized String renderDocumentation() {
        System.setProperty("cukedoctor.stopwatch", String.valueOf(System.currentTimeMillis()));
        this.docBuilder = CukedoctorDocumentBuilder.Factory.newInstance();
        this.addCustomPdfTheme();
        this.renderAttributes();
        this.docBuilder.newLine();
        this.docBuilder.documentTitle(Constants.Markup.bold(this.getDocumentationTitle()));
        this.renderIntro();
        if (!this.cukedoctorConfig.isHideSummarySection().booleanValue()) {
            this.renderSummary();
        } else {
            this.docBuilder.newLine();
        }
        this.renderFeatures(this.features);
        return this.docBuilder.toString();
    }

    private void renderIntro() {
        List<String> files = FileUtil.findFiles(this.cukedoctorConfig.getIntroChapterDir(), "cukedoctor-intro.adoc", true, this.cukedoctorConfig.getIntroChapterRelativePath());
        if (files != null && !files.isEmpty()) {
            String introPath = files.get(0);
            introPath = introPath.replaceAll("\\\\", "/");
            this.docBuilder.append("include::", introPath, "[leveloffset=+1]", Constants.newLine(), Constants.newLine());
        }
    }

    @Override
    public String getDocumentationTitle() {
        if (this.documentAttributes != null && Assert.hasText(this.documentAttributes.getDocTitle())) {
            return this.documentAttributes.getDocTitle();
        }
        return Constants.DOCUMENT_TITLE;
    }

    @Override
    public CukedoctorConverter renderAttributes() {
        if (this.documentAttributes != null) {
            this.docBuilder.attributes().toc(this.documentAttributes.getToc()).backend(this.documentAttributes.getBackend()).docTitle(this.documentAttributes.getDocTitle()).docType(this.documentAttributes.getDocType()).icons(this.documentAttributes.getIcons()).numbered(this.documentAttributes.isNumbered()).linkcss(this.documentAttributes.isLinkCss()).sectAnchors(this.documentAttributes.isSectAnchors()).sectLink(this.documentAttributes.isSectLink()).docInfo(this.documentAttributes.isDocInfo()).sourceHighlighter(this.documentAttributes.getSourceHighlighter()).tocLevels(this.documentAttributes.getTocLevels()).revNumber(this.documentAttributes.getRevNumber()).hardBreaks(this.documentAttributes.isHardBreaks()).chapterLabel(this.documentAttributes.getChapterLabel()).versionLabel(this.documentAttributes.getVersionLabel());
            if (Assert.hasText(this.documentAttributes.getPdfStyle())) {
                this.docBuilder.attributes().pdfStyle(this.documentAttributes.getPdfStyle());
            }
        }
        return this;
    }

    @Override
    public CukedoctorConverter addCustomPdfTheme() {
        if (Assert.notNull(this.documentAttributes) && this.documentAttributes.getBackend() != null && this.documentAttributes.getBackend().equalsIgnoreCase("pdf")) {
            String pdfThemeName = "cukedoctor-pdf.yml";
            List<String> files = FileUtil.findFiles(this.cukedoctorConfig.getCustomizationDir(), pdfThemeName, true);
            if (Assert.hasElements(files)) {
                String themePath = files.get(0);
                themePath = themePath.replaceAll("\\\\", "/");
                this.documentAttributes.pdfStyle(themePath);
            }
        }
        return this;
    }

    @Override
    public CukedoctorConverter addCustomCss() {
        return this;
    }

    @Override
    public CukedoctorConverter renderSummary() {
        if (this.summaryRenderer != null) {
            this.docBuilder.textLine(this.summaryRenderer.renderSummary(this.features));
        } else {
            this.summaryRenderer = new CukedoctorSummaryRenderer();
            this.docBuilder.textLine(this.summaryRenderer.renderSummary(this.features));
        }
        return this;
    }

    @Override
    public CukedoctorConverter renderFeatures(List<Feature> features) {
        this.docBuilder.append(this.featureRenderer.renderFeatures(features));
        return this;
    }

    @Override
    public CukedoctorConverter renderFeatures() {
        return this.renderFeatures(this.features);
    }

    @Override
    public CukedoctorConverter setFilename(String filename) {
        if (filename == null) {
            filename = this.getDocumentationTitle();
        }
        if (!filename.contains(".")) {
            filename = filename + ".adoc";
        }
        if (!FileUtil.ADOC_FILE_EXTENSION.matcher(filename = filename.replaceAll(" ", "_")).matches()) {
            throw new RuntimeException("Invalid filename extension for file: " + filename + ". Valid formats are: ad, adoc, asciidoc and asc");
        }
        this.filename = filename;
        return this;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public CukedoctorConverter saveDocumentation() {
        FileUtil.saveFile(this.filename, this.renderDocumentation());
        return this;
    }
}

