/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.toml.PackageVersion;
import com.fasterxml.jackson.dataformat.toml.Parser;
import com.fasterxml.jackson.dataformat.toml.TomlFactoryBuilder;
import com.fasterxml.jackson.dataformat.toml.TomlGenerator;
import com.fasterxml.jackson.dataformat.toml.TomlReadFeature;
import com.fasterxml.jackson.dataformat.toml.TomlWriteFeature;
import com.fasterxml.jackson.dataformat.toml.UTF8Reader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class TomlFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_TOML = "toml";
    static final int DEFAULT_TOML_PARSER_FEATURE_FLAGS = TomlReadFeature.collectDefaults();
    static final int DEFAULT_TOML_GENERATOR_FEATURE_FLAGS = TomlWriteFeature.collectDefaults();
    protected int _tomlParserFeatures;
    protected int _tomlGeneratorFeatures;

    public TomlFactory() {
        this._tomlParserFeatures = DEFAULT_TOML_PARSER_FEATURE_FLAGS;
        this._tomlGeneratorFeatures = DEFAULT_TOML_GENERATOR_FEATURE_FLAGS;
    }

    TomlFactory(TomlFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._tomlGeneratorFeatures = src._tomlGeneratorFeatures;
        this._tomlParserFeatures = src._tomlParserFeatures;
    }

    TomlFactory(TomlFactoryBuilder b) {
        super((TSFBuilder)b, false);
        this._tomlGeneratorFeatures = b._formatGeneratorFeatures;
        this._tomlParserFeatures = b._formatParserFeatures;
    }

    public TomlFactoryBuilder rebuild() {
        return new TomlFactoryBuilder(this);
    }

    public static TomlFactoryBuilder builder() {
        return new TomlFactoryBuilder();
    }

    public TomlFactory copy() {
        this._checkInvalidCopy(TomlFactory.class);
        return new TomlFactory(this, null);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_TOML;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return TomlReadFeature.class;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return TomlWriteFeature.class;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public final TomlFactory configure(TomlReadFeature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public TomlFactory enable(TomlReadFeature f) {
        this._tomlParserFeatures |= f.getMask();
        return this;
    }

    public TomlFactory disable(TomlReadFeature f) {
        this._tomlParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(TomlReadFeature f) {
        return (this._tomlParserFeatures & f.getMask()) != 0;
    }

    public int getFormatParserFeatures() {
        return this._tomlParserFeatures;
    }

    public final TomlFactory configure(TomlWriteFeature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public TomlFactory enable(TomlWriteFeature f) {
        this._tomlGeneratorFeatures |= f.getMask();
        return this;
    }

    public TomlFactory disable(TomlWriteFeature f) {
        this._tomlGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(TomlWriteFeature f) {
        return (this._tomlGeneratorFeatures & f.getMask()) != 0;
    }

    public int getFormatGeneratorFeatures() {
        return this._tomlGeneratorFeatures;
    }

    public JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return this._createParser(UTF8Reader.construct(ctxt, in, autoClose), ctxt);
    }

    public JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        ObjectNode node = this.parse(ctxt, r);
        return new TreeTraversingParser((JsonNode)node);
    }

    public JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return this._createParser(UTF8Reader.construct(data, offset, len), ctxt);
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this._createParser(new CharArrayReader(data, offset, len), ctxt);
    }

    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return new TomlGenerator(ctxt, this._generatorFeatures, this._tomlGeneratorFeatures, this._objectCodec, out);
    }

    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return new TomlGenerator(ctxt, this._generatorFeatures, this._tomlGeneratorFeatures, this._objectCodec, (Writer)new UTF8Writer(ctxt, out));
    }

    private ObjectNode parse(IOContext ctxt, Reader r0) throws IOException {
        if (ctxt.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
            try (Reader r = r0;){
                ObjectNode objectNode = Parser.parse(this, ctxt, r);
                return objectNode;
            }
        }
        return Parser.parse(this, ctxt, r0);
    }
}

