/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.Placeholder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderMatcher
implements Iterable<Placeholder> {
    private final String text;

    private PlaceholderMatcher(String text) {
        this.text = text;
    }

    public static Iterable<Placeholder> findPlaceholders(String text) {
        return new PlaceholderMatcher(text);
    }

    @Override
    public Iterator<Placeholder> iterator() {
        return new PlaceholderIterator(this.text);
    }

    private static class PlaceholderIterator
    implements Iterator<Placeholder> {
        private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{([^}]*)}+");
        private final Matcher matcher;
        private boolean hasNext;

        private PlaceholderIterator(String text) {
            this.matcher = PLACEHOLDER_PATTERN.matcher(text);
            this.hasNext = this.matcher.find();
        }

        private Placeholder getPlaceholder() {
            String placeholderString = this.matcher.group(1);
            Placeholder.Builder builder = Placeholder.parse(placeholderString);
            return builder.startIndex(this.matcher.start()).endIndex(this.matcher.end()).build();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Placeholder next() {
            if (this.hasNext()) {
                Placeholder placeholder = this.getPlaceholder();
                this.hasNext = this.matcher.find();
                return placeholder;
            }
            throw new NoSuchElementException();
        }
    }
}

