package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/**
 * Specifies one or more electronic seals to apply on documents. An electronic seal recipient is a
 * legal entity rather than an actual person. Electronic Seals can be used by organizations and
 * governments to show evidence of origin and integrity of documents. Even though electronic seals
 * can be represented by a tab in a document, they do not require user interaction and apply
 * automatically in the order specified by the sender. The sender is therefore the person
 * authorizing usage of the electronic seal in the flow. Example: &#x60;&#x60;&#x60;json
 * \&quot;recipients\&quot;: { \&quot;seals\&quot;: [ { \&quot;recipientId\&quot;: \&quot;1\&quot;,
 * \&quot;routingOrder\&quot; : 1, \&quot;recipientSignatureProviders\&quot;: [ {
 * \&quot;sealName\&quot;: \&quot;52e9d968-xxxx-xxxx-xxxx-4682bc45c106\&quot; } ] } ] }, . . .
 * &#x60;&#x60;&#x60; For more information about Electronic Seals, see [Apply Electronic Seals to
 * Your Documents](https://support.docusign.com/en/guides/ndse-user-guide-apply-electronic-seals). .
 */
@Schema(
    description =
        "Specifies one or more electronic seals to apply on documents. An electronic seal recipient is a legal entity rather than an actual person. Electronic Seals can be used by organizations and governments to show evidence of origin and integrity of documents. Even though electronic seals can be represented by a tab in a document, they do not require user interaction and apply automatically in the order specified by the sender. The sender is therefore the person authorizing usage of the electronic seal in the flow.  Example:   ```json \"recipients\": {       \"seals\": [         {           \"recipientId\": \"1\",           \"routingOrder\" : 1,           \"recipientSignatureProviders\": [             {               \"sealName\": \"52e9d968-xxxx-xxxx-xxxx-4682bc45c106\"             }        ]      }    ]  },     .     .     . ``` For more information about Electronic Seals, see [Apply Electronic Seals to Your Documents](https://support.docusign.com/en/guides/ndse-user-guide-apply-electronic-seals). ")
public class SealSign implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("accessCode")
  private String accessCode = null;

  @JsonProperty("accessCodeMetadata")
  private PropertyMetadata accessCodeMetadata = null;

  @JsonProperty("addAccessCodeToEmail")
  private String addAccessCodeToEmail = null;

  @JsonProperty("allowSystemOverrideForLockedRecipient")
  private String allowSystemOverrideForLockedRecipient = null;

  @JsonProperty("autoRespondedReason")
  private String autoRespondedReason = null;

  @JsonProperty("bulkSendV2Recipient")
  private String bulkSendV2Recipient = null;

  @JsonProperty("clientUserId")
  private String clientUserId = null;

  @JsonProperty("completedCount")
  private String completedCount = null;

  @JsonProperty("customFields")
  private java.util.List<String> customFields = null;

  @JsonProperty("declinedDateTime")
  private String declinedDateTime = null;

  @JsonProperty("declinedReason")
  private String declinedReason = null;

  @JsonProperty("deliveredDateTime")
  private String deliveredDateTime = null;

  @JsonProperty("deliveryMethod")
  private String deliveryMethod = null;

  @JsonProperty("deliveryMethodMetadata")
  private PropertyMetadata deliveryMethodMetadata = null;

  @JsonProperty("designatorId")
  private String designatorId = null;

  @JsonProperty("designatorIdGuid")
  private String designatorIdGuid = null;

  @JsonProperty("documentTemplateId")
  private String documentTemplateId = null;

  @JsonProperty("documentVisibility")
  private java.util.List<DocumentVisibility> documentVisibility = null;

  @JsonProperty("emailNotification")
  private RecipientEmailNotification emailNotification = null;

  @JsonProperty("embeddedRecipientStartURL")
  private String embeddedRecipientStartURL = null;

  @JsonProperty("errorDetails")
  private ErrorDetails errorDetails = null;

  @JsonProperty("faxNumber")
  private String faxNumber = null;

  @JsonProperty("faxNumberMetadata")
  private PropertyMetadata faxNumberMetadata = null;

  @JsonProperty("idCheckConfigurationName")
  private String idCheckConfigurationName = null;

  @JsonProperty("idCheckConfigurationNameMetadata")
  private PropertyMetadata idCheckConfigurationNameMetadata = null;

  @JsonProperty("idCheckInformationInput")
  private IdCheckInformationInput idCheckInformationInput = null;

  @JsonProperty("identityVerification")
  private RecipientIdentityVerification identityVerification = null;

  @JsonProperty("inheritEmailNotificationConfiguration")
  private String inheritEmailNotificationConfiguration = null;

  @JsonProperty("lockedRecipientPhoneAuthEditable")
  private String lockedRecipientPhoneAuthEditable = null;

  @JsonProperty("lockedRecipientSmsEditable")
  private String lockedRecipientSmsEditable = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("note")
  private String note = null;

  @JsonProperty("noteMetadata")
  private PropertyMetadata noteMetadata = null;

  @JsonProperty("phoneAuthentication")
  private RecipientPhoneAuthentication phoneAuthentication = null;

  @JsonProperty("proofFile")
  private RecipientProofFile proofFile = null;

  @JsonProperty("recipientAttachments")
  private java.util.List<RecipientAttachment> recipientAttachments = null;

  @JsonProperty("recipientAuthenticationStatus")
  private AuthenticationStatus recipientAuthenticationStatus = null;

  @JsonProperty("recipientFeatureMetadata")
  private java.util.List<FeatureAvailableMetadata> recipientFeatureMetadata = null;

  @JsonProperty("recipientId")
  private String recipientId = null;

  @JsonProperty("recipientIdGuid")
  private String recipientIdGuid = null;

  @JsonProperty("recipientSignatureProviders")
  private java.util.List<RecipientSignatureProvider> recipientSignatureProviders = null;

  @JsonProperty("recipientType")
  private String recipientType = null;

  @JsonProperty("recipientTypeMetadata")
  private PropertyMetadata recipientTypeMetadata = null;

  @JsonProperty("requireIdLookup")
  private String requireIdLookup = null;

  @JsonProperty("requireIdLookupMetadata")
  private PropertyMetadata requireIdLookupMetadata = null;

  @JsonProperty("roleName")
  private String roleName = null;

  @JsonProperty("routingOrder")
  private String routingOrder = null;

  @JsonProperty("routingOrderMetadata")
  private PropertyMetadata routingOrderMetadata = null;

  @JsonProperty("sentDateTime")
  private String sentDateTime = null;

  @JsonProperty("signedDateTime")
  private String signedDateTime = null;

  @JsonProperty("smsAuthentication")
  private RecipientSMSAuthentication smsAuthentication = null;

  @JsonProperty("socialAuthentications")
  private java.util.List<SocialAuthentication> socialAuthentications = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("statusCode")
  private String statusCode = null;

  @JsonProperty("suppressEmails")
  private String suppressEmails = null;

  @JsonProperty("tabs")
  private Tabs tabs = null;

  @JsonProperty("templateLocked")
  private String templateLocked = null;

  @JsonProperty("templateRequired")
  private String templateRequired = null;

  @JsonProperty("totalTabCount")
  private String totalTabCount = null;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("webFormRecipientViewId")
  private String webFormRecipientViewId = null;

  /**
   * accessCode.
   *
   * @return SealSign
   */
  public SealSign accessCode(String accessCode) {
    this.accessCode = accessCode;
    return this;
  }

  /**
   * If a value is provided, the recipient must enter the value as the access code to view and sign
   * the envelope. Maximum Length: 50 characters and it must conform to the account's access code
   * format setting. If blank, but the signer `accessCode` property is set in the envelope, then
   * that value is used. If blank and the signer `accessCode` property is not set, then the access
   * code is not required..
   *
   * @return accessCode
   */
  @Schema(
      description =
          "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
  public String getAccessCode() {
    return accessCode;
  }

  /** setAccessCode. */
  public void setAccessCode(String accessCode) {
    this.accessCode = accessCode;
  }

  /**
   * accessCodeMetadata.
   *
   * @return SealSign
   */
  public SealSign accessCodeMetadata(PropertyMetadata accessCodeMetadata) {
    this.accessCodeMetadata = accessCodeMetadata;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return accessCodeMetadata
   */
  @Schema(description = "Not applicable.")
  public PropertyMetadata getAccessCodeMetadata() {
    return accessCodeMetadata;
  }

  /** setAccessCodeMetadata. */
  public void setAccessCodeMetadata(PropertyMetadata accessCodeMetadata) {
    this.accessCodeMetadata = accessCodeMetadata;
  }

  /**
   * addAccessCodeToEmail.
   *
   * @return SealSign
   */
  public SealSign addAccessCodeToEmail(String addAccessCodeToEmail) {
    this.addAccessCodeToEmail = addAccessCodeToEmail;
    return this;
  }

  /**
   * This Optional attribute indicates that the access code will be added to the email sent to the
   * recipient; this nullifies the Security measure of Access Code on the recipient..
   *
   * @return addAccessCodeToEmail
   */
  @Schema(
      description =
          "This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.")
  public String getAddAccessCodeToEmail() {
    return addAccessCodeToEmail;
  }

  /** setAddAccessCodeToEmail. */
  public void setAddAccessCodeToEmail(String addAccessCodeToEmail) {
    this.addAccessCodeToEmail = addAccessCodeToEmail;
  }

  /**
   * allowSystemOverrideForLockedRecipient.
   *
   * @return SealSign
   */
  public SealSign allowSystemOverrideForLockedRecipient(
      String allowSystemOverrideForLockedRecipient) {
    this.allowSystemOverrideForLockedRecipient = allowSystemOverrideForLockedRecipient;
    return this;
  }

  /**
   * .
   *
   * @return allowSystemOverrideForLockedRecipient
   */
  @Schema(description = "")
  public String getAllowSystemOverrideForLockedRecipient() {
    return allowSystemOverrideForLockedRecipient;
  }

  /** setAllowSystemOverrideForLockedRecipient. */
  public void setAllowSystemOverrideForLockedRecipient(
      String allowSystemOverrideForLockedRecipient) {
    this.allowSystemOverrideForLockedRecipient = allowSystemOverrideForLockedRecipient;
  }

  /**
   * autoRespondedReason.
   *
   * @return SealSign
   */
  public SealSign autoRespondedReason(String autoRespondedReason) {
    this.autoRespondedReason = autoRespondedReason;
    return this;
  }

  /**
   * .
   *
   * @return autoRespondedReason
   */
  @Schema(description = "")
  public String getAutoRespondedReason() {
    return autoRespondedReason;
  }

  /** setAutoRespondedReason. */
  public void setAutoRespondedReason(String autoRespondedReason) {
    this.autoRespondedReason = autoRespondedReason;
  }

  /**
   * bulkSendV2Recipient.
   *
   * @return SealSign
   */
  public SealSign bulkSendV2Recipient(String bulkSendV2Recipient) {
    this.bulkSendV2Recipient = bulkSendV2Recipient;
    return this;
  }

  /**
   * .
   *
   * @return bulkSendV2Recipient
   */
  @Schema(description = "")
  public String getBulkSendV2Recipient() {
    return bulkSendV2Recipient;
  }

  /** setBulkSendV2Recipient. */
  public void setBulkSendV2Recipient(String bulkSendV2Recipient) {
    this.bulkSendV2Recipient = bulkSendV2Recipient;
  }

  /**
   * clientUserId.
   *
   * @return SealSign
   */
  public SealSign clientUserId(String clientUserId) {
    this.clientUserId = clientUserId;
    return this;
  }

  /**
   * Specifies whether the recipient is embedded or remote. If the `clientUserId` property is not
   * null then the recipient is embedded. Note that if the `ClientUserId` property is set and either
   * `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to
   * **true**, an error is generated on sending.ng. Maximum length: 100 characters. .
   *
   * @return clientUserId
   */
  @Schema(
      description =
          "Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
  public String getClientUserId() {
    return clientUserId;
  }

  /** setClientUserId. */
  public void setClientUserId(String clientUserId) {
    this.clientUserId = clientUserId;
  }

  /**
   * completedCount.
   *
   * @return SealSign
   */
  public SealSign completedCount(String completedCount) {
    this.completedCount = completedCount;
    return this;
  }

  /**
   * .
   *
   * @return completedCount
   */
  @Schema(description = "")
  public String getCompletedCount() {
    return completedCount;
  }

  /** setCompletedCount. */
  public void setCompletedCount(String completedCount) {
    this.completedCount = completedCount;
  }

  /**
   * customFields.
   *
   * @return SealSign
   */
  public SealSign customFields(java.util.List<String> customFields) {
    this.customFields = customFields;
    return this;
  }

  /**
   * addCustomFieldsItem.
   *
   * @return SealSign
   */
  public SealSign addCustomFieldsItem(String customFieldsItem) {
    if (this.customFields == null) {
      this.customFields = new java.util.ArrayList<>();
    }
    this.customFields.add(customFieldsItem);
    return this;
  }

  /**
   * An optional array of strings that allows the sender to provide custom data about the recipient.
   * This information is returned in the envelope status but otherwise not used by DocuSign. Each
   * customField string can be a maximum of 100 characters..
   *
   * @return customFields
   */
  @Schema(
      description =
          "An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
  public java.util.List<String> getCustomFields() {
    return customFields;
  }

  /** setCustomFields. */
  public void setCustomFields(java.util.List<String> customFields) {
    this.customFields = customFields;
  }

  /**
   * declinedDateTime.
   *
   * @return SealSign
   */
  public SealSign declinedDateTime(String declinedDateTime) {
    this.declinedDateTime = declinedDateTime;
    return this;
  }

  /**
   * The date and time the recipient declined the document..
   *
   * @return declinedDateTime
   */
  @Schema(description = "The date and time the recipient declined the document.")
  public String getDeclinedDateTime() {
    return declinedDateTime;
  }

  /** setDeclinedDateTime. */
  public void setDeclinedDateTime(String declinedDateTime) {
    this.declinedDateTime = declinedDateTime;
  }

  /**
   * declinedReason.
   *
   * @return SealSign
   */
  public SealSign declinedReason(String declinedReason) {
    this.declinedReason = declinedReason;
    return this;
  }

  /**
   * The reason the recipient declined the document..
   *
   * @return declinedReason
   */
  @Schema(description = "The reason the recipient declined the document.")
  public String getDeclinedReason() {
    return declinedReason;
  }

  /** setDeclinedReason. */
  public void setDeclinedReason(String declinedReason) {
    this.declinedReason = declinedReason;
  }

  /**
   * deliveredDateTime.
   *
   * @return SealSign
   */
  public SealSign deliveredDateTime(String deliveredDateTime) {
    this.deliveredDateTime = deliveredDateTime;
    return this;
  }

  /**
   * Reserved: For DocuSign use only..
   *
   * @return deliveredDateTime
   */
  @Schema(description = "Reserved: For DocuSign use only.")
  public String getDeliveredDateTime() {
    return deliveredDateTime;
  }

  /** setDeliveredDateTime. */
  public void setDeliveredDateTime(String deliveredDateTime) {
    this.deliveredDateTime = deliveredDateTime;
  }

  /**
   * deliveryMethod.
   *
   * @return SealSign
   */
  public SealSign deliveryMethod(String deliveryMethod) {
    this.deliveryMethod = deliveryMethod;
    return this;
  }

  /**
   * Reserved: For DocuSign use only..
   *
   * @return deliveryMethod
   */
  @Schema(description = "Reserved: For DocuSign use only.")
  public String getDeliveryMethod() {
    return deliveryMethod;
  }

  /** setDeliveryMethod. */
  public void setDeliveryMethod(String deliveryMethod) {
    this.deliveryMethod = deliveryMethod;
  }

  /**
   * deliveryMethodMetadata.
   *
   * @return SealSign
   */
  public SealSign deliveryMethodMetadata(PropertyMetadata deliveryMethodMetadata) {
    this.deliveryMethodMetadata = deliveryMethodMetadata;
    return this;
  }

  /**
   * Reserved for DocuSign..
   *
   * @return deliveryMethodMetadata
   */
  @Schema(description = "Reserved for DocuSign.")
  public PropertyMetadata getDeliveryMethodMetadata() {
    return deliveryMethodMetadata;
  }

  /** setDeliveryMethodMetadata. */
  public void setDeliveryMethodMetadata(PropertyMetadata deliveryMethodMetadata) {
    this.deliveryMethodMetadata = deliveryMethodMetadata;
  }

  /**
   * designatorId.
   *
   * @return SealSign
   */
  public SealSign designatorId(String designatorId) {
    this.designatorId = designatorId;
    return this;
  }

  /**
   * .
   *
   * @return designatorId
   */
  @Schema(description = "")
  public String getDesignatorId() {
    return designatorId;
  }

  /** setDesignatorId. */
  public void setDesignatorId(String designatorId) {
    this.designatorId = designatorId;
  }

  /**
   * designatorIdGuid.
   *
   * @return SealSign
   */
  public SealSign designatorIdGuid(String designatorIdGuid) {
    this.designatorIdGuid = designatorIdGuid;
    return this;
  }

  /**
   * .
   *
   * @return designatorIdGuid
   */
  @Schema(description = "")
  public String getDesignatorIdGuid() {
    return designatorIdGuid;
  }

  /** setDesignatorIdGuid. */
  public void setDesignatorIdGuid(String designatorIdGuid) {
    this.designatorIdGuid = designatorIdGuid;
  }

  /**
   * documentTemplateId.
   *
   * @return SealSign
   */
  public SealSign documentTemplateId(String documentTemplateId) {
    this.documentTemplateId = documentTemplateId;
    return this;
  }

  /**
   * .
   *
   * @return documentTemplateId
   */
  @Schema(description = "")
  public String getDocumentTemplateId() {
    return documentTemplateId;
  }

  /** setDocumentTemplateId. */
  public void setDocumentTemplateId(String documentTemplateId) {
    this.documentTemplateId = documentTemplateId;
  }

  /**
   * documentVisibility.
   *
   * @return SealSign
   */
  public SealSign documentVisibility(java.util.List<DocumentVisibility> documentVisibility) {
    this.documentVisibility = documentVisibility;
    return this;
  }

  /**
   * addDocumentVisibilityItem.
   *
   * @return SealSign
   */
  public SealSign addDocumentVisibilityItem(DocumentVisibility documentVisibilityItem) {
    if (this.documentVisibility == null) {
      this.documentVisibility = new java.util.ArrayList<>();
    }
    this.documentVisibility.add(documentVisibilityItem);
    return this;
  }

  /**
   * .
   *
   * @return documentVisibility
   */
  @Schema(description = "")
  public java.util.List<DocumentVisibility> getDocumentVisibility() {
    return documentVisibility;
  }

  /** setDocumentVisibility. */
  public void setDocumentVisibility(java.util.List<DocumentVisibility> documentVisibility) {
    this.documentVisibility = documentVisibility;
  }

  /**
   * emailNotification.
   *
   * @return SealSign
   */
  public SealSign emailNotification(RecipientEmailNotification emailNotification) {
    this.emailNotification = emailNotification;
    return this;
  }

  /**
   * A complex type that contains information sets the language of the recipient's email
   * information. **IMPORTANT**: If you enable email notification for one recipient, you must enable
   * email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb`
   * property settings. .
   *
   * @return emailNotification
   */
  @Schema(
      description =
          "A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings. ")
  public RecipientEmailNotification getEmailNotification() {
    return emailNotification;
  }

  /** setEmailNotification. */
  public void setEmailNotification(RecipientEmailNotification emailNotification) {
    this.emailNotification = emailNotification;
  }

  /**
   * embeddedRecipientStartURL.
   *
   * @return SealSign
   */
  public SealSign embeddedRecipientStartURL(String embeddedRecipientStartURL) {
    this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    return this;
  }

  /**
   * Specifies a sender provided valid URL string for redirecting an embedded recipient. When using
   * this option, the embedded recipient still receives an email from DocuSign, just as a remote
   * recipient would. When the document link in the email is clicked the recipient is redirected,
   * through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the
   * sender's system (the server responding to the URL) must request a recipient token to launch a
   * signing session. If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing
   * or viewing process directly at DocuSign. The signing or viewing action is initiated by the
   * DocuSign system and the transaction activity and Certificate of Completion records will reflect
   * this. In all other ways the process is identical to an embedded signing or viewing operation
   * that is launched by any partner. It is important to remember that in a typical embedded
   * workflow the authentication of an embedded recipient is the responsibility of the sending
   * application, DocuSign expects that senders will follow their own process for establishing the
   * recipient's identity. In this workflow the recipient goes through the sending application
   * before the embedded signing or viewing process in initiated. However, when the sending
   * application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to
   * the embedded signing or viewing process bypassing the sending application and any
   * authentication steps the sending application would use. In this case, DocuSign recommends that
   * you use one of the normal DocuSign authentication features (Access Code, Phone Authentication,
   * SMS Authentication, etc.) to verify the identity of the recipient. If the `clientUserId`
   * property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the
   * redirect URL and launch the standard signing process for the email recipient. Information can
   * be appended to the embedded recipient start URL using merge fields. The available merge fields
   * items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The
   * `customFields` property must be set fort the recipient or envelope. The merge fields are
   * enclosed in double brackets. *Example*: `http://senderHost/[[mergeField1]]/
   * beginSigningSession? [[mergeField2]]&[[mergeField3]]` .
   *
   * @return embeddedRecipientStartURL
   */
  @Schema(
      description =
          "Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ")
  public String getEmbeddedRecipientStartURL() {
    return embeddedRecipientStartURL;
  }

  /** setEmbeddedRecipientStartURL. */
  public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
    this.embeddedRecipientStartURL = embeddedRecipientStartURL;
  }

  /**
   * errorDetails.
   *
   * @return SealSign
   */
  public SealSign errorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
    return this;
  }

  /**
   * Array or errors..
   *
   * @return errorDetails
   */
  @Schema(description = "Array or errors.")
  public ErrorDetails getErrorDetails() {
    return errorDetails;
  }

  /** setErrorDetails. */
  public void setErrorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
  }

  /**
   * faxNumber.
   *
   * @return SealSign
   */
  public SealSign faxNumber(String faxNumber) {
    this.faxNumber = faxNumber;
    return this;
  }

  /**
   * Reserved:.
   *
   * @return faxNumber
   */
  @Schema(description = "Reserved:")
  public String getFaxNumber() {
    return faxNumber;
  }

  /** setFaxNumber. */
  public void setFaxNumber(String faxNumber) {
    this.faxNumber = faxNumber;
  }

  /**
   * faxNumberMetadata.
   *
   * @return SealSign
   */
  public SealSign faxNumberMetadata(PropertyMetadata faxNumberMetadata) {
    this.faxNumberMetadata = faxNumberMetadata;
    return this;
  }

  /**
   * Reserved for DocuSign..
   *
   * @return faxNumberMetadata
   */
  @Schema(description = "Reserved for DocuSign.")
  public PropertyMetadata getFaxNumberMetadata() {
    return faxNumberMetadata;
  }

  /** setFaxNumberMetadata. */
  public void setFaxNumberMetadata(PropertyMetadata faxNumberMetadata) {
    this.faxNumberMetadata = faxNumberMetadata;
  }

  /**
   * idCheckConfigurationName.
   *
   * @return SealSign
   */
  public SealSign idCheckConfigurationName(String idCheckConfigurationName) {
    this.idCheckConfigurationName = idCheckConfigurationName;
    return this;
  }

  /**
   * Specifies authentication check by name. The names used here must be the same as the
   * authentication type names used by the account (these name can also be found in the web console
   * sending interface in the Identify list for a recipient,) This overrides any default
   * authentication setting. *Example*: Your account has ID Check and SMS Authentication available
   * and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID
   * check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use
   * SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number
   * information to the `smsAuthentication` node..
   *
   * @return idCheckConfigurationName
   */
  @Schema(
      description =
          "Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.")
  public String getIdCheckConfigurationName() {
    return idCheckConfigurationName;
  }

  /** setIdCheckConfigurationName. */
  public void setIdCheckConfigurationName(String idCheckConfigurationName) {
    this.idCheckConfigurationName = idCheckConfigurationName;
  }

  /**
   * idCheckConfigurationNameMetadata.
   *
   * @return SealSign
   */
  public SealSign idCheckConfigurationNameMetadata(
      PropertyMetadata idCheckConfigurationNameMetadata) {
    this.idCheckConfigurationNameMetadata = idCheckConfigurationNameMetadata;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return idCheckConfigurationNameMetadata
   */
  @Schema(description = "Not applicable.")
  public PropertyMetadata getIdCheckConfigurationNameMetadata() {
    return idCheckConfigurationNameMetadata;
  }

  /** setIdCheckConfigurationNameMetadata. */
  public void setIdCheckConfigurationNameMetadata(
      PropertyMetadata idCheckConfigurationNameMetadata) {
    this.idCheckConfigurationNameMetadata = idCheckConfigurationNameMetadata;
  }

  /**
   * idCheckInformationInput.
   *
   * @return SealSign
   */
  public SealSign idCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
    this.idCheckInformationInput = idCheckInformationInput;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return idCheckInformationInput
   */
  @Schema(description = "Not applicable.")
  public IdCheckInformationInput getIdCheckInformationInput() {
    return idCheckInformationInput;
  }

  /** setIdCheckInformationInput. */
  public void setIdCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
    this.idCheckInformationInput = idCheckInformationInput;
  }

  /**
   * identityVerification.
   *
   * @return SealSign
   */
  public SealSign identityVerification(RecipientIdentityVerification identityVerification) {
    this.identityVerification = identityVerification;
    return this;
  }

  /**
   * Specifies the ID Verification workflow applied on an envelope by workflow ID. <br>
   * See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in
   * the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/)
   * resource for more information on how to retrieve workflow IDs available for an account. <br>
   * This can be used in addition to other [recipient
   * authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication)
   * methods. <br>
   * Note that ID Verification and ID Check are two distinct methods. ID Verification checks
   * recipients' identity by verifying their ID while ID Check relies on data available on public
   * records (such as current and former address)..
   *
   * @return identityVerification
   */
  @Schema(
      description =
          "Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).")
  public RecipientIdentityVerification getIdentityVerification() {
    return identityVerification;
  }

  /** setIdentityVerification. */
  public void setIdentityVerification(RecipientIdentityVerification identityVerification) {
    this.identityVerification = identityVerification;
  }

  /**
   * inheritEmailNotificationConfiguration.
   *
   * @return SealSign
   */
  public SealSign inheritEmailNotificationConfiguration(
      String inheritEmailNotificationConfiguration) {
    this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
    return this;
  }

  /**
   * When set to **true** and the envelope recipient creates a DocuSign account after signing, the
   * Manage Account Email Notification settings are used as the default settings for the recipient's
   * account. .
   *
   * @return inheritEmailNotificationConfiguration
   */
  @Schema(
      description =
          "When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ")
  public String getInheritEmailNotificationConfiguration() {
    return inheritEmailNotificationConfiguration;
  }

  /** setInheritEmailNotificationConfiguration. */
  public void setInheritEmailNotificationConfiguration(
      String inheritEmailNotificationConfiguration) {
    this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
  }

  /**
   * lockedRecipientPhoneAuthEditable.
   *
   * @return SealSign
   */
  public SealSign lockedRecipientPhoneAuthEditable(String lockedRecipientPhoneAuthEditable) {
    this.lockedRecipientPhoneAuthEditable = lockedRecipientPhoneAuthEditable;
    return this;
  }

  /**
   * .
   *
   * @return lockedRecipientPhoneAuthEditable
   */
  @Schema(description = "")
  public String getLockedRecipientPhoneAuthEditable() {
    return lockedRecipientPhoneAuthEditable;
  }

  /** setLockedRecipientPhoneAuthEditable. */
  public void setLockedRecipientPhoneAuthEditable(String lockedRecipientPhoneAuthEditable) {
    this.lockedRecipientPhoneAuthEditable = lockedRecipientPhoneAuthEditable;
  }

  /**
   * lockedRecipientSmsEditable.
   *
   * @return SealSign
   */
  public SealSign lockedRecipientSmsEditable(String lockedRecipientSmsEditable) {
    this.lockedRecipientSmsEditable = lockedRecipientSmsEditable;
    return this;
  }

  /**
   * .
   *
   * @return lockedRecipientSmsEditable
   */
  @Schema(description = "")
  public String getLockedRecipientSmsEditable() {
    return lockedRecipientSmsEditable;
  }

  /** setLockedRecipientSmsEditable. */
  public void setLockedRecipientSmsEditable(String lockedRecipientSmsEditable) {
    this.lockedRecipientSmsEditable = lockedRecipientSmsEditable;
  }

  /**
   * name.
   *
   * @return SealSign
   */
  public SealSign name(String name) {
    this.name = name;
    return this;
  }

  /**
   * .
   *
   * @return name
   */
  @Schema(description = "")
  public String getName() {
    return name;
  }

  /** setName. */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * note.
   *
   * @return SealSign
   */
  public SealSign note(String note) {
    this.note = note;
    return this;
  }

  /**
   * Specifies a note that is unique to this recipient. This note is sent to the recipient via the
   * signing email. The note displays in the signing UI near the upper left corner of the document
   * on the signing screen. Maximum Length: 1000 characters..
   *
   * @return note
   */
  @Schema(
      description =
          "Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.")
  public String getNote() {
    return note;
  }

  /** setNote. */
  public void setNote(String note) {
    this.note = note;
  }

  /**
   * noteMetadata.
   *
   * @return SealSign
   */
  public SealSign noteMetadata(PropertyMetadata noteMetadata) {
    this.noteMetadata = noteMetadata;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return noteMetadata
   */
  @Schema(description = "Not applicable.")
  public PropertyMetadata getNoteMetadata() {
    return noteMetadata;
  }

  /** setNoteMetadata. */
  public void setNoteMetadata(PropertyMetadata noteMetadata) {
    this.noteMetadata = noteMetadata;
  }

  /**
   * phoneAuthentication.
   *
   * @return SealSign
   */
  public SealSign phoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
    this.phoneAuthentication = phoneAuthentication;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return phoneAuthentication
   */
  @Schema(description = "Not applicable.")
  public RecipientPhoneAuthentication getPhoneAuthentication() {
    return phoneAuthentication;
  }

  /** setPhoneAuthentication. */
  public void setPhoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
    this.phoneAuthentication = phoneAuthentication;
  }

  /**
   * proofFile.
   *
   * @return SealSign
   */
  public SealSign proofFile(RecipientProofFile proofFile) {
    this.proofFile = proofFile;
    return this;
  }

  /**
   * .
   *
   * @return proofFile
   */
  @Schema(description = "")
  public RecipientProofFile getProofFile() {
    return proofFile;
  }

  /** setProofFile. */
  public void setProofFile(RecipientProofFile proofFile) {
    this.proofFile = proofFile;
  }

  /**
   * recipientAttachments.
   *
   * @return SealSign
   */
  public SealSign recipientAttachments(java.util.List<RecipientAttachment> recipientAttachments) {
    this.recipientAttachments = recipientAttachments;
    return this;
  }

  /**
   * addRecipientAttachmentsItem.
   *
   * @return SealSign
   */
  public SealSign addRecipientAttachmentsItem(RecipientAttachment recipientAttachmentsItem) {
    if (this.recipientAttachments == null) {
      this.recipientAttachments = new java.util.ArrayList<>();
    }
    this.recipientAttachments.add(recipientAttachmentsItem);
    return this;
  }

  /**
   * Reserved:.
   *
   * @return recipientAttachments
   */
  @Schema(description = "Reserved:")
  public java.util.List<RecipientAttachment> getRecipientAttachments() {
    return recipientAttachments;
  }

  /** setRecipientAttachments. */
  public void setRecipientAttachments(java.util.List<RecipientAttachment> recipientAttachments) {
    this.recipientAttachments = recipientAttachments;
  }

  /**
   * recipientAuthenticationStatus.
   *
   * @return SealSign
   */
  public SealSign recipientAuthenticationStatus(
      AuthenticationStatus recipientAuthenticationStatus) {
    this.recipientAuthenticationStatus = recipientAuthenticationStatus;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return recipientAuthenticationStatus
   */
  @Schema(description = "Not applicable.")
  public AuthenticationStatus getRecipientAuthenticationStatus() {
    return recipientAuthenticationStatus;
  }

  /** setRecipientAuthenticationStatus. */
  public void setRecipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
    this.recipientAuthenticationStatus = recipientAuthenticationStatus;
  }

  /**
   * recipientFeatureMetadata.
   *
   * @return SealSign
   */
  public SealSign recipientFeatureMetadata(
      java.util.List<FeatureAvailableMetadata> recipientFeatureMetadata) {
    this.recipientFeatureMetadata = recipientFeatureMetadata;
    return this;
  }

  /**
   * addRecipientFeatureMetadataItem.
   *
   * @return SealSign
   */
  public SealSign addRecipientFeatureMetadataItem(
      FeatureAvailableMetadata recipientFeatureMetadataItem) {
    if (this.recipientFeatureMetadata == null) {
      this.recipientFeatureMetadata = new java.util.ArrayList<>();
    }
    this.recipientFeatureMetadata.add(recipientFeatureMetadataItem);
    return this;
  }

  /**
   * .
   *
   * @return recipientFeatureMetadata
   */
  @Schema(description = "")
  public java.util.List<FeatureAvailableMetadata> getRecipientFeatureMetadata() {
    return recipientFeatureMetadata;
  }

  /** setRecipientFeatureMetadata. */
  public void setRecipientFeatureMetadata(
      java.util.List<FeatureAvailableMetadata> recipientFeatureMetadata) {
    this.recipientFeatureMetadata = recipientFeatureMetadata;
  }

  /**
   * recipientId.
   *
   * @return SealSign
   */
  public SealSign recipientId(String recipientId) {
    this.recipientId = recipientId;
    return this;
  }

  /**
   * Unique for the recipient. It is used by the tab element to indicate which recipient is to sign
   * the Document..
   *
   * @return recipientId
   */
  @Schema(
      description =
          "Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
  public String getRecipientId() {
    return recipientId;
  }

  /** setRecipientId. */
  public void setRecipientId(String recipientId) {
    this.recipientId = recipientId;
  }

  /**
   * recipientIdGuid.
   *
   * @return SealSign
   */
  public SealSign recipientIdGuid(String recipientIdGuid) {
    this.recipientIdGuid = recipientIdGuid;
    return this;
  }

  /**
   * .
   *
   * @return recipientIdGuid
   */
  @Schema(description = "")
  public String getRecipientIdGuid() {
    return recipientIdGuid;
  }

  /** setRecipientIdGuid. */
  public void setRecipientIdGuid(String recipientIdGuid) {
    this.recipientIdGuid = recipientIdGuid;
  }

  /**
   * recipientSignatureProviders.
   *
   * @return SealSign
   */
  public SealSign recipientSignatureProviders(
      java.util.List<RecipientSignatureProvider> recipientSignatureProviders) {
    this.recipientSignatureProviders = recipientSignatureProviders;
    return this;
  }

  /**
   * addRecipientSignatureProvidersItem.
   *
   * @return SealSign
   */
  public SealSign addRecipientSignatureProvidersItem(
      RecipientSignatureProvider recipientSignatureProvidersItem) {
    if (this.recipientSignatureProviders == null) {
      this.recipientSignatureProviders = new java.util.ArrayList<>();
    }
    this.recipientSignatureProviders.add(recipientSignatureProvidersItem);
    return this;
  }

  /**
   * .
   *
   * @return recipientSignatureProviders
   */
  @Schema(description = "")
  public java.util.List<RecipientSignatureProvider> getRecipientSignatureProviders() {
    return recipientSignatureProviders;
  }

  /** setRecipientSignatureProviders. */
  public void setRecipientSignatureProviders(
      java.util.List<RecipientSignatureProvider> recipientSignatureProviders) {
    this.recipientSignatureProviders = recipientSignatureProviders;
  }

  /**
   * recipientType.
   *
   * @return SealSign
   */
  public SealSign recipientType(String recipientType) {
    this.recipientType = recipientType;
    return this;
  }

  /**
   * .
   *
   * @return recipientType
   */
  @Schema(description = "")
  public String getRecipientType() {
    return recipientType;
  }

  /** setRecipientType. */
  public void setRecipientType(String recipientType) {
    this.recipientType = recipientType;
  }

  /**
   * recipientTypeMetadata.
   *
   * @return SealSign
   */
  public SealSign recipientTypeMetadata(PropertyMetadata recipientTypeMetadata) {
    this.recipientTypeMetadata = recipientTypeMetadata;
    return this;
  }

  /**
   * Metadata that indicates whether the `recipientType` property is editable. This property is
   * read-only..
   *
   * @return recipientTypeMetadata
   */
  @Schema(
      description =
          "Metadata that indicates whether the `recipientType` property is editable. This property is read-only.")
  public PropertyMetadata getRecipientTypeMetadata() {
    return recipientTypeMetadata;
  }

  /** setRecipientTypeMetadata. */
  public void setRecipientTypeMetadata(PropertyMetadata recipientTypeMetadata) {
    this.recipientTypeMetadata = recipientTypeMetadata;
  }

  /**
   * requireIdLookup.
   *
   * @return SealSign
   */
  public SealSign requireIdLookup(String requireIdLookup) {
    this.requireIdLookup = requireIdLookup;
    return this;
  }

  /**
   * When set to **true**, the recipient is required to use the specified ID check method (including
   * Phone and SMS authentication) to validate their identity. .
   *
   * @return requireIdLookup
   */
  @Schema(
      description =
          "When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ")
  public String getRequireIdLookup() {
    return requireIdLookup;
  }

  /** setRequireIdLookup. */
  public void setRequireIdLookup(String requireIdLookup) {
    this.requireIdLookup = requireIdLookup;
  }

  /**
   * requireIdLookupMetadata.
   *
   * @return SealSign
   */
  public SealSign requireIdLookupMetadata(PropertyMetadata requireIdLookupMetadata) {
    this.requireIdLookupMetadata = requireIdLookupMetadata;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return requireIdLookupMetadata
   */
  @Schema(description = "Not applicable.")
  public PropertyMetadata getRequireIdLookupMetadata() {
    return requireIdLookupMetadata;
  }

  /** setRequireIdLookupMetadata. */
  public void setRequireIdLookupMetadata(PropertyMetadata requireIdLookupMetadata) {
    this.requireIdLookupMetadata = requireIdLookupMetadata;
  }

  /**
   * roleName.
   *
   * @return SealSign
   */
  public SealSign roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

  /**
   * Optional element. Specifies the role name associated with the recipient.<br>
   * <br>
   * This is required when working with template recipients..
   *
   * @return roleName
   */
  @Schema(
      description =
          "Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
  public String getRoleName() {
    return roleName;
  }

  /** setRoleName. */
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  /**
   * routingOrder.
   *
   * @return SealSign
   */
  public SealSign routingOrder(String routingOrder) {
    this.routingOrder = routingOrder;
    return this;
  }

  /**
   * Specifies the routing order of the recipient in the envelope. .
   *
   * @return routingOrder
   */
  @Schema(description = "Specifies the routing order of the recipient in the envelope. ")
  public String getRoutingOrder() {
    return routingOrder;
  }

  /** setRoutingOrder. */
  public void setRoutingOrder(String routingOrder) {
    this.routingOrder = routingOrder;
  }

  /**
   * routingOrderMetadata.
   *
   * @return SealSign
   */
  public SealSign routingOrderMetadata(PropertyMetadata routingOrderMetadata) {
    this.routingOrderMetadata = routingOrderMetadata;
    return this;
  }

  /**
   * Metadata that indicates whether the `routingOrder` property is editable. This property is
   * read-only..
   *
   * @return routingOrderMetadata
   */
  @Schema(
      description =
          "Metadata that indicates whether the `routingOrder` property is editable. This property is read-only.")
  public PropertyMetadata getRoutingOrderMetadata() {
    return routingOrderMetadata;
  }

  /** setRoutingOrderMetadata. */
  public void setRoutingOrderMetadata(PropertyMetadata routingOrderMetadata) {
    this.routingOrderMetadata = routingOrderMetadata;
  }

  /**
   * sentDateTime.
   *
   * @return SealSign
   */
  public SealSign sentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
    return this;
  }

  /**
   * The date and time the envelope was sent..
   *
   * @return sentDateTime
   */
  @Schema(description = "The date and time the envelope was sent.")
  public String getSentDateTime() {
    return sentDateTime;
  }

  /** setSentDateTime. */
  public void setSentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
  }

  /**
   * signedDateTime.
   *
   * @return SealSign
   */
  public SealSign signedDateTime(String signedDateTime) {
    this.signedDateTime = signedDateTime;
    return this;
  }

  /**
   * Reserved: For DocuSign use only. .
   *
   * @return signedDateTime
   */
  @Schema(description = "Reserved: For DocuSign use only. ")
  public String getSignedDateTime() {
    return signedDateTime;
  }

  /** setSignedDateTime. */
  public void setSignedDateTime(String signedDateTime) {
    this.signedDateTime = signedDateTime;
  }

  /**
   * smsAuthentication.
   *
   * @return SealSign
   */
  public SealSign smsAuthentication(RecipientSMSAuthentication smsAuthentication) {
    this.smsAuthentication = smsAuthentication;
    return this;
  }

  /**
   * Not applicable..
   *
   * @return smsAuthentication
   */
  @Schema(description = "Not applicable.")
  public RecipientSMSAuthentication getSmsAuthentication() {
    return smsAuthentication;
  }

  /** setSmsAuthentication. */
  public void setSmsAuthentication(RecipientSMSAuthentication smsAuthentication) {
    this.smsAuthentication = smsAuthentication;
  }

  /**
   * socialAuthentications.
   *
   * @return SealSign
   */
  public SealSign socialAuthentications(
      java.util.List<SocialAuthentication> socialAuthentications) {
    this.socialAuthentications = socialAuthentications;
    return this;
  }

  /**
   * addSocialAuthenticationsItem.
   *
   * @return SealSign
   */
  public SealSign addSocialAuthenticationsItem(SocialAuthentication socialAuthenticationsItem) {
    if (this.socialAuthentications == null) {
      this.socialAuthentications = new java.util.ArrayList<>();
    }
    this.socialAuthentications.add(socialAuthenticationsItem);
    return this;
  }

  /**
   * Lists the social ID type that can be used for recipient authentication..
   *
   * @return socialAuthentications
   */
  @Schema(description = " Lists the social ID type that can be used for recipient authentication.")
  public java.util.List<SocialAuthentication> getSocialAuthentications() {
    return socialAuthentications;
  }

  /** setSocialAuthentications. */
  public void setSocialAuthentications(java.util.List<SocialAuthentication> socialAuthentications) {
    this.socialAuthentications = socialAuthentications;
  }

  /**
   * status.
   *
   * @return SealSign
   */
  public SealSign status(String status) {
    this.status = status;
    return this;
  }

  /**
   * Indicates the envelope status. Valid values are: * sent - The envelope is sent to the
   * recipients. * created - The envelope is saved as a draft and can be modified and sent later..
   *
   * @return status
   */
  @Schema(
      description =
          "Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
  public String getStatus() {
    return status;
  }

  /** setStatus. */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * statusCode.
   *
   * @return SealSign
   */
  public SealSign statusCode(String statusCode) {
    this.statusCode = statusCode;
    return this;
  }

  /**
   * .
   *
   * @return statusCode
   */
  @Schema(description = "")
  public String getStatusCode() {
    return statusCode;
  }

  /** setStatusCode. */
  public void setStatusCode(String statusCode) {
    this.statusCode = statusCode;
  }

  /**
   * suppressEmails.
   *
   * @return SealSign
   */
  public SealSign suppressEmails(String suppressEmails) {
    this.suppressEmails = suppressEmails;
    return this;
  }

  /**
   * .
   *
   * @return suppressEmails
   */
  @Schema(description = "")
  public String getSuppressEmails() {
    return suppressEmails;
  }

  /** setSuppressEmails. */
  public void setSuppressEmails(String suppressEmails) {
    this.suppressEmails = suppressEmails;
  }

  /**
   * tabs.
   *
   * @return SealSign
   */
  public SealSign tabs(Tabs tabs) {
    this.tabs = tabs;
    return this;
  }

  /**
   * A list of tabs, which are represented graphically as symbols on documents at the time of
   * signing. Tabs show recipients where to sign, initial, or enter data. They may also display data
   * to the recipients..
   *
   * @return tabs
   */
  @Schema(
      description =
          "A list of tabs, which are represented graphically as symbols on documents at the time of signing. Tabs show recipients where to sign, initial, or enter data. They may also display data to the recipients.")
  public Tabs getTabs() {
    return tabs;
  }

  /** setTabs. */
  public void setTabs(Tabs tabs) {
    this.tabs = tabs;
  }

  /**
   * templateLocked.
   *
   * @return SealSign
   */
  public SealSign templateLocked(String templateLocked) {
    this.templateLocked = templateLocked;
    return this;
  }

  /**
   * When set to **true**, the sender cannot change any attributes of the recipient. Used only when
   * working with template recipients. .
   *
   * @return templateLocked
   */
  @Schema(
      description =
          "When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. ")
  public String getTemplateLocked() {
    return templateLocked;
  }

  /** setTemplateLocked. */
  public void setTemplateLocked(String templateLocked) {
    this.templateLocked = templateLocked;
  }

  /**
   * templateRequired.
   *
   * @return SealSign
   */
  public SealSign templateRequired(String templateRequired) {
    this.templateRequired = templateRequired;
    return this;
  }

  /**
   * When set to **true**, the sender may not remove the recipient. Used only when working with
   * template recipients..
   *
   * @return templateRequired
   */
  @Schema(
      description =
          "When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.")
  public String getTemplateRequired() {
    return templateRequired;
  }

  /** setTemplateRequired. */
  public void setTemplateRequired(String templateRequired) {
    this.templateRequired = templateRequired;
  }

  /**
   * totalTabCount.
   *
   * @return SealSign
   */
  public SealSign totalTabCount(String totalTabCount) {
    this.totalTabCount = totalTabCount;
    return this;
  }

  /**
   * .
   *
   * @return totalTabCount
   */
  @Schema(description = "")
  public String getTotalTabCount() {
    return totalTabCount;
  }

  /** setTotalTabCount. */
  public void setTotalTabCount(String totalTabCount) {
    this.totalTabCount = totalTabCount;
  }

  /**
   * userId.
   *
   * @return SealSign
   */
  public SealSign userId(String userId) {
    this.userId = userId;
    return this;
  }

  /**
   * .
   *
   * @return userId
   */
  @Schema(description = "")
  public String getUserId() {
    return userId;
  }

  /** setUserId. */
  public void setUserId(String userId) {
    this.userId = userId;
  }

  /**
   * webFormRecipientViewId.
   *
   * @return SealSign
   */
  public SealSign webFormRecipientViewId(String webFormRecipientViewId) {
    this.webFormRecipientViewId = webFormRecipientViewId;
    return this;
  }

  /**
   * .
   *
   * @return webFormRecipientViewId
   */
  @Schema(description = "")
  public String getWebFormRecipientViewId() {
    return webFormRecipientViewId;
  }

  /** setWebFormRecipientViewId. */
  public void setWebFormRecipientViewId(String webFormRecipientViewId) {
    this.webFormRecipientViewId = webFormRecipientViewId;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SealSign sealSign = (SealSign) o;
    return Objects.equals(this.accessCode, sealSign.accessCode)
        && Objects.equals(this.accessCodeMetadata, sealSign.accessCodeMetadata)
        && Objects.equals(this.addAccessCodeToEmail, sealSign.addAccessCodeToEmail)
        && Objects.equals(
            this.allowSystemOverrideForLockedRecipient,
            sealSign.allowSystemOverrideForLockedRecipient)
        && Objects.equals(this.autoRespondedReason, sealSign.autoRespondedReason)
        && Objects.equals(this.bulkSendV2Recipient, sealSign.bulkSendV2Recipient)
        && Objects.equals(this.clientUserId, sealSign.clientUserId)
        && Objects.equals(this.completedCount, sealSign.completedCount)
        && Objects.equals(this.customFields, sealSign.customFields)
        && Objects.equals(this.declinedDateTime, sealSign.declinedDateTime)
        && Objects.equals(this.declinedReason, sealSign.declinedReason)
        && Objects.equals(this.deliveredDateTime, sealSign.deliveredDateTime)
        && Objects.equals(this.deliveryMethod, sealSign.deliveryMethod)
        && Objects.equals(this.deliveryMethodMetadata, sealSign.deliveryMethodMetadata)
        && Objects.equals(this.designatorId, sealSign.designatorId)
        && Objects.equals(this.designatorIdGuid, sealSign.designatorIdGuid)
        && Objects.equals(this.documentTemplateId, sealSign.documentTemplateId)
        && Objects.equals(this.documentVisibility, sealSign.documentVisibility)
        && Objects.equals(this.emailNotification, sealSign.emailNotification)
        && Objects.equals(this.embeddedRecipientStartURL, sealSign.embeddedRecipientStartURL)
        && Objects.equals(this.errorDetails, sealSign.errorDetails)
        && Objects.equals(this.faxNumber, sealSign.faxNumber)
        && Objects.equals(this.faxNumberMetadata, sealSign.faxNumberMetadata)
        && Objects.equals(this.idCheckConfigurationName, sealSign.idCheckConfigurationName)
        && Objects.equals(
            this.idCheckConfigurationNameMetadata, sealSign.idCheckConfigurationNameMetadata)
        && Objects.equals(this.idCheckInformationInput, sealSign.idCheckInformationInput)
        && Objects.equals(this.identityVerification, sealSign.identityVerification)
        && Objects.equals(
            this.inheritEmailNotificationConfiguration,
            sealSign.inheritEmailNotificationConfiguration)
        && Objects.equals(
            this.lockedRecipientPhoneAuthEditable, sealSign.lockedRecipientPhoneAuthEditable)
        && Objects.equals(this.lockedRecipientSmsEditable, sealSign.lockedRecipientSmsEditable)
        && Objects.equals(this.name, sealSign.name)
        && Objects.equals(this.note, sealSign.note)
        && Objects.equals(this.noteMetadata, sealSign.noteMetadata)
        && Objects.equals(this.phoneAuthentication, sealSign.phoneAuthentication)
        && Objects.equals(this.proofFile, sealSign.proofFile)
        && Objects.equals(this.recipientAttachments, sealSign.recipientAttachments)
        && Objects.equals(
            this.recipientAuthenticationStatus, sealSign.recipientAuthenticationStatus)
        && Objects.equals(this.recipientFeatureMetadata, sealSign.recipientFeatureMetadata)
        && Objects.equals(this.recipientId, sealSign.recipientId)
        && Objects.equals(this.recipientIdGuid, sealSign.recipientIdGuid)
        && Objects.equals(this.recipientSignatureProviders, sealSign.recipientSignatureProviders)
        && Objects.equals(this.recipientType, sealSign.recipientType)
        && Objects.equals(this.recipientTypeMetadata, sealSign.recipientTypeMetadata)
        && Objects.equals(this.requireIdLookup, sealSign.requireIdLookup)
        && Objects.equals(this.requireIdLookupMetadata, sealSign.requireIdLookupMetadata)
        && Objects.equals(this.roleName, sealSign.roleName)
        && Objects.equals(this.routingOrder, sealSign.routingOrder)
        && Objects.equals(this.routingOrderMetadata, sealSign.routingOrderMetadata)
        && Objects.equals(this.sentDateTime, sealSign.sentDateTime)
        && Objects.equals(this.signedDateTime, sealSign.signedDateTime)
        && Objects.equals(this.smsAuthentication, sealSign.smsAuthentication)
        && Objects.equals(this.socialAuthentications, sealSign.socialAuthentications)
        && Objects.equals(this.status, sealSign.status)
        && Objects.equals(this.statusCode, sealSign.statusCode)
        && Objects.equals(this.suppressEmails, sealSign.suppressEmails)
        && Objects.equals(this.tabs, sealSign.tabs)
        && Objects.equals(this.templateLocked, sealSign.templateLocked)
        && Objects.equals(this.templateRequired, sealSign.templateRequired)
        && Objects.equals(this.totalTabCount, sealSign.totalTabCount)
        && Objects.equals(this.userId, sealSign.userId)
        && Objects.equals(this.webFormRecipientViewId, sealSign.webFormRecipientViewId);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(
        accessCode,
        accessCodeMetadata,
        addAccessCodeToEmail,
        allowSystemOverrideForLockedRecipient,
        autoRespondedReason,
        bulkSendV2Recipient,
        clientUserId,
        completedCount,
        customFields,
        declinedDateTime,
        declinedReason,
        deliveredDateTime,
        deliveryMethod,
        deliveryMethodMetadata,
        designatorId,
        designatorIdGuid,
        documentTemplateId,
        documentVisibility,
        emailNotification,
        embeddedRecipientStartURL,
        errorDetails,
        faxNumber,
        faxNumberMetadata,
        idCheckConfigurationName,
        idCheckConfigurationNameMetadata,
        idCheckInformationInput,
        identityVerification,
        inheritEmailNotificationConfiguration,
        lockedRecipientPhoneAuthEditable,
        lockedRecipientSmsEditable,
        name,
        note,
        noteMetadata,
        phoneAuthentication,
        proofFile,
        recipientAttachments,
        recipientAuthenticationStatus,
        recipientFeatureMetadata,
        recipientId,
        recipientIdGuid,
        recipientSignatureProviders,
        recipientType,
        recipientTypeMetadata,
        requireIdLookup,
        requireIdLookupMetadata,
        roleName,
        routingOrder,
        routingOrderMetadata,
        sentDateTime,
        signedDateTime,
        smsAuthentication,
        socialAuthentications,
        status,
        statusCode,
        suppressEmails,
        tabs,
        templateLocked,
        templateRequired,
        totalTabCount,
        userId,
        webFormRecipientViewId);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SealSign {\n");

    sb.append("    accessCode: ").append(toIndentedString(accessCode)).append("\n");
    sb.append("    accessCodeMetadata: ").append(toIndentedString(accessCodeMetadata)).append("\n");
    sb.append("    addAccessCodeToEmail: ")
        .append(toIndentedString(addAccessCodeToEmail))
        .append("\n");
    sb.append("    allowSystemOverrideForLockedRecipient: ")
        .append(toIndentedString(allowSystemOverrideForLockedRecipient))
        .append("\n");
    sb.append("    autoRespondedReason: ")
        .append(toIndentedString(autoRespondedReason))
        .append("\n");
    sb.append("    bulkSendV2Recipient: ")
        .append(toIndentedString(bulkSendV2Recipient))
        .append("\n");
    sb.append("    clientUserId: ").append(toIndentedString(clientUserId)).append("\n");
    sb.append("    completedCount: ").append(toIndentedString(completedCount)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    declinedDateTime: ").append(toIndentedString(declinedDateTime)).append("\n");
    sb.append("    declinedReason: ").append(toIndentedString(declinedReason)).append("\n");
    sb.append("    deliveredDateTime: ").append(toIndentedString(deliveredDateTime)).append("\n");
    sb.append("    deliveryMethod: ").append(toIndentedString(deliveryMethod)).append("\n");
    sb.append("    deliveryMethodMetadata: ")
        .append(toIndentedString(deliveryMethodMetadata))
        .append("\n");
    sb.append("    designatorId: ").append(toIndentedString(designatorId)).append("\n");
    sb.append("    designatorIdGuid: ").append(toIndentedString(designatorIdGuid)).append("\n");
    sb.append("    documentTemplateId: ").append(toIndentedString(documentTemplateId)).append("\n");
    sb.append("    documentVisibility: ").append(toIndentedString(documentVisibility)).append("\n");
    sb.append("    emailNotification: ").append(toIndentedString(emailNotification)).append("\n");
    sb.append("    embeddedRecipientStartURL: ")
        .append(toIndentedString(embeddedRecipientStartURL))
        .append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    faxNumber: ").append(toIndentedString(faxNumber)).append("\n");
    sb.append("    faxNumberMetadata: ").append(toIndentedString(faxNumberMetadata)).append("\n");
    sb.append("    idCheckConfigurationName: ")
        .append(toIndentedString(idCheckConfigurationName))
        .append("\n");
    sb.append("    idCheckConfigurationNameMetadata: ")
        .append(toIndentedString(idCheckConfigurationNameMetadata))
        .append("\n");
    sb.append("    idCheckInformationInput: ")
        .append(toIndentedString(idCheckInformationInput))
        .append("\n");
    sb.append("    identityVerification: ")
        .append(toIndentedString(identityVerification))
        .append("\n");
    sb.append("    inheritEmailNotificationConfiguration: ")
        .append(toIndentedString(inheritEmailNotificationConfiguration))
        .append("\n");
    sb.append("    lockedRecipientPhoneAuthEditable: ")
        .append(toIndentedString(lockedRecipientPhoneAuthEditable))
        .append("\n");
    sb.append("    lockedRecipientSmsEditable: ")
        .append(toIndentedString(lockedRecipientSmsEditable))
        .append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    noteMetadata: ").append(toIndentedString(noteMetadata)).append("\n");
    sb.append("    phoneAuthentication: ")
        .append(toIndentedString(phoneAuthentication))
        .append("\n");
    sb.append("    proofFile: ").append(toIndentedString(proofFile)).append("\n");
    sb.append("    recipientAttachments: ")
        .append(toIndentedString(recipientAttachments))
        .append("\n");
    sb.append("    recipientAuthenticationStatus: ")
        .append(toIndentedString(recipientAuthenticationStatus))
        .append("\n");
    sb.append("    recipientFeatureMetadata: ")
        .append(toIndentedString(recipientFeatureMetadata))
        .append("\n");
    sb.append("    recipientId: ").append(toIndentedString(recipientId)).append("\n");
    sb.append("    recipientIdGuid: ").append(toIndentedString(recipientIdGuid)).append("\n");
    sb.append("    recipientSignatureProviders: ")
        .append(toIndentedString(recipientSignatureProviders))
        .append("\n");
    sb.append("    recipientType: ").append(toIndentedString(recipientType)).append("\n");
    sb.append("    recipientTypeMetadata: ")
        .append(toIndentedString(recipientTypeMetadata))
        .append("\n");
    sb.append("    requireIdLookup: ").append(toIndentedString(requireIdLookup)).append("\n");
    sb.append("    requireIdLookupMetadata: ")
        .append(toIndentedString(requireIdLookupMetadata))
        .append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("    routingOrder: ").append(toIndentedString(routingOrder)).append("\n");
    sb.append("    routingOrderMetadata: ")
        .append(toIndentedString(routingOrderMetadata))
        .append("\n");
    sb.append("    sentDateTime: ").append(toIndentedString(sentDateTime)).append("\n");
    sb.append("    signedDateTime: ").append(toIndentedString(signedDateTime)).append("\n");
    sb.append("    smsAuthentication: ").append(toIndentedString(smsAuthentication)).append("\n");
    sb.append("    socialAuthentications: ")
        .append(toIndentedString(socialAuthentications))
        .append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusCode: ").append(toIndentedString(statusCode)).append("\n");
    sb.append("    suppressEmails: ").append(toIndentedString(suppressEmails)).append("\n");
    sb.append("    tabs: ").append(toIndentedString(tabs)).append("\n");
    sb.append("    templateLocked: ").append(toIndentedString(templateLocked)).append("\n");
    sb.append("    templateRequired: ").append(toIndentedString(templateRequired)).append("\n");
    sb.append("    totalTabCount: ").append(toIndentedString(totalTabCount)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    webFormRecipientViewId: ")
        .append(toIndentedString(webFormRecipientViewId))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
