/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.api.listener;

import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeService;
import com.dangdang.ddframe.job.util.env.TimeService;

public abstract class AbstractDistributeOnceElasticJobListener
implements ElasticJobListener {
    private final long startedTimeoutMilliseconds;
    private final Object startedWait = new Object();
    private final long completedTimeoutMilliseconds;
    private final Object completedWait = new Object();
    private GuaranteeService guaranteeService;
    private TimeService timeService = new TimeService();

    public AbstractDistributeOnceElasticJobListener(long startedTimeoutMilliseconds, long completedTimeoutMilliseconds) {
        this.startedTimeoutMilliseconds = startedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : startedTimeoutMilliseconds;
        this.completedTimeoutMilliseconds = completedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : completedTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void beforeJobExecuted(ShardingContexts shardingContexts) {
        this.guaranteeService.registerStart(shardingContexts.getShardingItemParameters().keySet());
        if (this.guaranteeService.isAllStarted()) {
            this.doBeforeJobExecutedAtLastStarted(shardingContexts);
            this.guaranteeService.clearAllStartedInfo();
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.startedWait;
            synchronized (object) {
                this.startedWait.wait(this.startedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.startedTimeoutMilliseconds) {
            this.guaranteeService.clearAllStartedInfo();
            this.handleTimeout(this.startedTimeoutMilliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void afterJobExecuted(ShardingContexts shardingContexts) {
        this.guaranteeService.registerComplete(shardingContexts.getShardingItemParameters().keySet());
        if (this.guaranteeService.isAllCompleted()) {
            this.doAfterJobExecutedAtLastCompleted(shardingContexts);
            this.guaranteeService.clearAllCompletedInfo();
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.completedWait;
            synchronized (object) {
                this.completedWait.wait(this.completedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.completedTimeoutMilliseconds) {
            this.guaranteeService.clearAllCompletedInfo();
            this.handleTimeout(this.completedTimeoutMilliseconds);
        }
    }

    private void handleTimeout(long timeoutMilliseconds) {
        throw new JobSystemException("Job timeout. timeout mills is %s.", new Object[]{timeoutMilliseconds});
    }

    public abstract void doBeforeJobExecutedAtLastStarted(ShardingContexts var1);

    public abstract void doAfterJobExecutedAtLastCompleted(ShardingContexts var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskStart() {
        Object object = this.startedWait;
        synchronized (object) {
            this.startedWait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskComplete() {
        Object object = this.completedWait;
        synchronized (object) {
            this.completedWait.notifyAll();
        }
    }

    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }
}

