/*
 * Decompiled with CFR 0.152.
 */
package com.cj.jshintmojo.jshint;

import com.cj.jshintmojo.util.Rhino;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;

public class JSHint {
    private final Rhino rhino = new Rhino();

    public JSHint(String jshintCode) {
        try {
            this.rhino.eval("print=function(){};quit=function(){};arguments=[];");
            this.rhino.eval(this.commentOutTheShebang(this.resourceAsString(jshintCode)));
        }
        catch (EcmaError e) {
            throw new RuntimeException("Javascript eval error:" + e.getScriptStackTrace(), e);
        }
    }

    private String commentOutTheShebang(String code) {
        String minusShebang = code.startsWith("#!") ? "//" + code : code;
        return minusShebang;
    }

    public List<Error> run(InputStream source, String options, String globals) {
        ArrayList<Error> results = new ArrayList<Error>();
        String sourceAsText = JSHint.toString(source);
        NativeObject nativeOptions = this.toJsObject(options);
        NativeObject nativeGlobals = this.toJsObject(globals);
        Boolean codePassesMuster = (Boolean)this.rhino.call("JSHINT", sourceAsText, nativeOptions, nativeGlobals);
        if (!codePassesMuster.booleanValue()) {
            NativeArray errors = (NativeArray)this.rhino.eval("JSHINT.errors");
            for (Object next : errors) {
                if (next == null) continue;
                Error error = new Error(new JSObject(next));
                results.add(error);
            }
        }
        return results;
    }

    private NativeObject toJsObject(String options) {
        NativeObject nativeOptions = new NativeObject();
        for (String nextOption : options.split(",")) {
            Object value;
            String name;
            String option = nextOption.trim();
            if (option.isEmpty()) continue;
            int valueDelimiter = option.indexOf(58);
            if (valueDelimiter == -1) {
                name = option;
                value = Boolean.TRUE;
            } else {
                name = option.substring(0, valueDelimiter);
                String rest = option.substring(valueDelimiter + 1).trim();
                value = rest.matches("[0-9]+") ? Integer.valueOf(Integer.parseInt(rest)) : (rest.equals("true") ? Boolean.TRUE : (rest.equals("false") ? Boolean.FALSE : rest));
            }
            nativeOptions.defineProperty(name, value, 1);
        }
        return nativeOptions;
    }

    private static String toString(InputStream in) {
        try {
            return IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String resourceAsString(String name) {
        return JSHint.toString(this.getClass().getResourceAsStream(name));
    }

    public static class Error
    implements Serializable {
        public String id;
        public String code;
        public String raw;
        public String evidence;
        public String reason;
        public Number line;
        public Number character;

        public Error(JSObject o) {
            this.id = this.nullSafeToString(o, "id");
            this.code = this.nullSafeToString(o, "code");
            this.raw = this.nullSafeToString(o, "raw");
            this.evidence = this.nullSafeToString(o, "evidence");
            this.line = (Number)o.dot("line");
            this.character = (Number)o.dot("character");
            this.reason = this.nullSafeToString(o, "reason");
        }

        private String nullSafeToString(JSObject o, String name) {
            return o.dot(name) != null ? o.dot(name).toString() : "";
        }

        public Error() {
        }
    }

    static class JSObject {
        private NativeObject a;

        public JSObject(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            this.a = (NativeObject)o;
        }

        public <T> T dot(String name) {
            return (T)this.a.get((Object)name);
        }
    }
}

