/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.metadatataxonomies;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.metadatataxonomies.AddMetadataTaxonomyLevelHeaders;
import com.box.sdkgen.managers.metadatataxonomies.AddMetadataTaxonomyLevelRequestBody;
import com.box.sdkgen.managers.metadatataxonomies.CreateMetadataTaxonomyHeaders;
import com.box.sdkgen.managers.metadatataxonomies.CreateMetadataTaxonomyLevelHeaders;
import com.box.sdkgen.managers.metadatataxonomies.CreateMetadataTaxonomyNodeHeaders;
import com.box.sdkgen.managers.metadatataxonomies.CreateMetadataTaxonomyNodeRequestBody;
import com.box.sdkgen.managers.metadatataxonomies.CreateMetadataTaxonomyRequestBody;
import com.box.sdkgen.managers.metadatataxonomies.DeleteMetadataTaxonomyHeaders;
import com.box.sdkgen.managers.metadatataxonomies.DeleteMetadataTaxonomyLevelHeaders;
import com.box.sdkgen.managers.metadatataxonomies.DeleteMetadataTaxonomyNodeHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomiesHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomiesQueryParams;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomyByKeyHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomyNodeByIdHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomyNodesHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTaxonomyNodesQueryParams;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTemplateFieldOptionsHeaders;
import com.box.sdkgen.managers.metadatataxonomies.GetMetadataTemplateFieldOptionsQueryParams;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyHeaders;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyLevelByIdHeaders;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyLevelByIdRequestBody;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyNodeHeaders;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyNodeRequestBody;
import com.box.sdkgen.managers.metadatataxonomies.UpdateMetadataTaxonomyRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.metadatataxonomies.MetadataTaxonomies;
import com.box.sdkgen.schemas.metadatataxonomy.MetadataTaxonomy;
import com.box.sdkgen.schemas.metadatataxonomylevel.MetadataTaxonomyLevel;
import com.box.sdkgen.schemas.metadatataxonomylevels.MetadataTaxonomyLevels;
import com.box.sdkgen.schemas.metadatataxonomynode.MetadataTaxonomyNode;
import com.box.sdkgen.schemas.metadatataxonomynodes.MetadataTaxonomyNodes;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.List;
import java.util.Map;

public class MetadataTaxonomiesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public MetadataTaxonomiesManager() {
        this.networkSession = new NetworkSession();
    }

    protected MetadataTaxonomiesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public MetadataTaxonomy createMetadataTaxonomy(CreateMetadataTaxonomyRequestBody requestBody) {
        return this.createMetadataTaxonomy(requestBody, new CreateMetadataTaxonomyHeaders());
    }

    public MetadataTaxonomy createMetadataTaxonomy(CreateMetadataTaxonomyRequestBody requestBody, CreateMetadataTaxonomyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomy.class);
    }

    public MetadataTaxonomies getMetadataTaxonomies(String namespace) {
        return this.getMetadataTaxonomies(namespace, new GetMetadataTaxonomiesQueryParams(), new GetMetadataTaxonomiesHeaders());
    }

    public MetadataTaxonomies getMetadataTaxonomies(String namespace, GetMetadataTaxonomiesQueryParams queryParams) {
        return this.getMetadataTaxonomies(namespace, queryParams, new GetMetadataTaxonomiesHeaders());
    }

    public MetadataTaxonomies getMetadataTaxonomies(String namespace, GetMetadataTaxonomiesHeaders headers) {
        return this.getMetadataTaxonomies(namespace, new GetMetadataTaxonomiesQueryParams(), headers);
    }

    public MetadataTaxonomies getMetadataTaxonomies(String namespace, GetMetadataTaxonomiesQueryParams queryParams, GetMetadataTaxonomiesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomies.class);
    }

    public MetadataTaxonomy getMetadataTaxonomyByKey(String namespace, String taxonomyKey) {
        return this.getMetadataTaxonomyByKey(namespace, taxonomyKey, new GetMetadataTaxonomyByKeyHeaders());
    }

    public MetadataTaxonomy getMetadataTaxonomyByKey(String namespace, String taxonomyKey, GetMetadataTaxonomyByKeyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomy.class);
    }

    public MetadataTaxonomy updateMetadataTaxonomy(String namespace, String taxonomyKey, UpdateMetadataTaxonomyRequestBody requestBody) {
        return this.updateMetadataTaxonomy(namespace, taxonomyKey, requestBody, new UpdateMetadataTaxonomyHeaders());
    }

    public MetadataTaxonomy updateMetadataTaxonomy(String namespace, String taxonomyKey, UpdateMetadataTaxonomyRequestBody requestBody, UpdateMetadataTaxonomyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey)), "PATCH").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomy.class);
    }

    public void deleteMetadataTaxonomy(String namespace, String taxonomyKey) {
        this.deleteMetadataTaxonomy(namespace, taxonomyKey, new DeleteMetadataTaxonomyHeaders());
    }

    public void deleteMetadataTaxonomy(String namespace, String taxonomyKey, DeleteMetadataTaxonomyHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public MetadataTaxonomyLevels createMetadataTaxonomyLevel(String namespace, String taxonomyKey, List<MetadataTaxonomyLevel> requestBody) {
        return this.createMetadataTaxonomyLevel(namespace, taxonomyKey, requestBody, new CreateMetadataTaxonomyLevelHeaders());
    }

    public MetadataTaxonomyLevels createMetadataTaxonomyLevel(String namespace, String taxonomyKey, List<MetadataTaxonomyLevel> requestBody, CreateMetadataTaxonomyLevelHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/levels"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyLevels.class);
    }

    public MetadataTaxonomyLevel updateMetadataTaxonomyLevelById(String namespace, String taxonomyKey, long levelIndex, UpdateMetadataTaxonomyLevelByIdRequestBody requestBody) {
        return this.updateMetadataTaxonomyLevelById(namespace, taxonomyKey, levelIndex, requestBody, new UpdateMetadataTaxonomyLevelByIdHeaders());
    }

    public MetadataTaxonomyLevel updateMetadataTaxonomyLevelById(String namespace, String taxonomyKey, long levelIndex, UpdateMetadataTaxonomyLevelByIdRequestBody requestBody, UpdateMetadataTaxonomyLevelByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/levels/", UtilsManager.convertToString(levelIndex)), "PATCH").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyLevel.class);
    }

    public MetadataTaxonomyLevels addMetadataTaxonomyLevel(String namespace, String taxonomyKey, AddMetadataTaxonomyLevelRequestBody requestBody) {
        return this.addMetadataTaxonomyLevel(namespace, taxonomyKey, requestBody, new AddMetadataTaxonomyLevelHeaders());
    }

    public MetadataTaxonomyLevels addMetadataTaxonomyLevel(String namespace, String taxonomyKey, AddMetadataTaxonomyLevelRequestBody requestBody, AddMetadataTaxonomyLevelHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/levels:append"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyLevels.class);
    }

    public MetadataTaxonomyLevels deleteMetadataTaxonomyLevel(String namespace, String taxonomyKey) {
        return this.deleteMetadataTaxonomyLevel(namespace, taxonomyKey, new DeleteMetadataTaxonomyLevelHeaders());
    }

    public MetadataTaxonomyLevels deleteMetadataTaxonomyLevel(String namespace, String taxonomyKey, DeleteMetadataTaxonomyLevelHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/levels:trim"), "POST").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyLevels.class);
    }

    public MetadataTaxonomyNodes getMetadataTaxonomyNodes(String namespace, String taxonomyKey) {
        return this.getMetadataTaxonomyNodes(namespace, taxonomyKey, new GetMetadataTaxonomyNodesQueryParams(), new GetMetadataTaxonomyNodesHeaders());
    }

    public MetadataTaxonomyNodes getMetadataTaxonomyNodes(String namespace, String taxonomyKey, GetMetadataTaxonomyNodesQueryParams queryParams) {
        return this.getMetadataTaxonomyNodes(namespace, taxonomyKey, queryParams, new GetMetadataTaxonomyNodesHeaders());
    }

    public MetadataTaxonomyNodes getMetadataTaxonomyNodes(String namespace, String taxonomyKey, GetMetadataTaxonomyNodesHeaders headers) {
        return this.getMetadataTaxonomyNodes(namespace, taxonomyKey, new GetMetadataTaxonomyNodesQueryParams(), headers);
    }

    public MetadataTaxonomyNodes getMetadataTaxonomyNodes(String namespace, String taxonomyKey, GetMetadataTaxonomyNodesQueryParams queryParams, GetMetadataTaxonomyNodesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("level", UtilsManager.convertToString(queryParams.getLevel())), UtilsManager.entryOf("parent", UtilsManager.convertToString(queryParams.getParent())), UtilsManager.entryOf("ancestor", UtilsManager.convertToString(queryParams.getAncestor())), UtilsManager.entryOf("query", UtilsManager.convertToString(queryParams.getQuery())), UtilsManager.entryOf("include-total-result-count", UtilsManager.convertToString(queryParams.getIncludeTotalResultCount())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/nodes"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyNodes.class);
    }

    public MetadataTaxonomyNode createMetadataTaxonomyNode(String namespace, String taxonomyKey, CreateMetadataTaxonomyNodeRequestBody requestBody) {
        return this.createMetadataTaxonomyNode(namespace, taxonomyKey, requestBody, new CreateMetadataTaxonomyNodeHeaders());
    }

    public MetadataTaxonomyNode createMetadataTaxonomyNode(String namespace, String taxonomyKey, CreateMetadataTaxonomyNodeRequestBody requestBody, CreateMetadataTaxonomyNodeHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/nodes"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyNode.class);
    }

    public MetadataTaxonomyNode getMetadataTaxonomyNodeById(String namespace, String taxonomyKey, String nodeId) {
        return this.getMetadataTaxonomyNodeById(namespace, taxonomyKey, nodeId, new GetMetadataTaxonomyNodeByIdHeaders());
    }

    public MetadataTaxonomyNode getMetadataTaxonomyNodeById(String namespace, String taxonomyKey, String nodeId, GetMetadataTaxonomyNodeByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/nodes/", UtilsManager.convertToString(nodeId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyNode.class);
    }

    public MetadataTaxonomyNode updateMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId) {
        return this.updateMetadataTaxonomyNode(namespace, taxonomyKey, nodeId, new UpdateMetadataTaxonomyNodeRequestBody(), new UpdateMetadataTaxonomyNodeHeaders());
    }

    public MetadataTaxonomyNode updateMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId, UpdateMetadataTaxonomyNodeRequestBody requestBody) {
        return this.updateMetadataTaxonomyNode(namespace, taxonomyKey, nodeId, requestBody, new UpdateMetadataTaxonomyNodeHeaders());
    }

    public MetadataTaxonomyNode updateMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId, UpdateMetadataTaxonomyNodeHeaders headers) {
        return this.updateMetadataTaxonomyNode(namespace, taxonomyKey, nodeId, new UpdateMetadataTaxonomyNodeRequestBody(), headers);
    }

    public MetadataTaxonomyNode updateMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId, UpdateMetadataTaxonomyNodeRequestBody requestBody, UpdateMetadataTaxonomyNodeHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/nodes/", UtilsManager.convertToString(nodeId)), "PATCH").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyNode.class);
    }

    public void deleteMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId) {
        this.deleteMetadataTaxonomyNode(namespace, taxonomyKey, nodeId, new DeleteMetadataTaxonomyNodeHeaders());
    }

    public void deleteMetadataTaxonomyNode(String namespace, String taxonomyKey, String nodeId, DeleteMetadataTaxonomyNodeHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_taxonomies/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(taxonomyKey), "/nodes/", UtilsManager.convertToString(nodeId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public MetadataTaxonomyNodes getMetadataTemplateFieldOptions(String namespace, String templateKey, String fieldKey) {
        return this.getMetadataTemplateFieldOptions(namespace, templateKey, fieldKey, new GetMetadataTemplateFieldOptionsQueryParams(), new GetMetadataTemplateFieldOptionsHeaders());
    }

    public MetadataTaxonomyNodes getMetadataTemplateFieldOptions(String namespace, String templateKey, String fieldKey, GetMetadataTemplateFieldOptionsQueryParams queryParams) {
        return this.getMetadataTemplateFieldOptions(namespace, templateKey, fieldKey, queryParams, new GetMetadataTemplateFieldOptionsHeaders());
    }

    public MetadataTaxonomyNodes getMetadataTemplateFieldOptions(String namespace, String templateKey, String fieldKey, GetMetadataTemplateFieldOptionsHeaders headers) {
        return this.getMetadataTemplateFieldOptions(namespace, templateKey, fieldKey, new GetMetadataTemplateFieldOptionsQueryParams(), headers);
    }

    public MetadataTaxonomyNodes getMetadataTemplateFieldOptions(String namespace, String templateKey, String fieldKey, GetMetadataTemplateFieldOptionsQueryParams queryParams, GetMetadataTemplateFieldOptionsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("level", UtilsManager.convertToString(queryParams.getLevel())), UtilsManager.entryOf("parent", UtilsManager.convertToString(queryParams.getParent())), UtilsManager.entryOf("ancestor", UtilsManager.convertToString(queryParams.getAncestor())), UtilsManager.entryOf("query", UtilsManager.convertToString(queryParams.getQuery())), UtilsManager.entryOf("include-total-result-count", UtilsManager.convertToString(queryParams.getIncludeTotalResultCount())), UtilsManager.entryOf("only-selectable-options", UtilsManager.convertToString(queryParams.getOnlySelectableOptions())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_templates/", UtilsManager.convertToString(namespace), "/", UtilsManager.convertToString(templateKey), "/fields/", UtilsManager.convertToString(fieldKey), "/options"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataTaxonomyNodes.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public MetadataTaxonomiesManager build() {
            return new MetadataTaxonomiesManager(this);
        }
    }
}

