/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.IpRule;
import com.azure.resourcemanager.keyvault.models.NetworkRuleAction;
import com.azure.resourcemanager.keyvault.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.keyvault.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkRuleSet {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkRuleSet.class);
    @JsonProperty(value="bypass")
    private NetworkRuleBypassOptions bypass;
    @JsonProperty(value="defaultAction")
    private NetworkRuleAction defaultAction;
    @JsonProperty(value="ipRules")
    private List<IpRule> ipRules;
    @JsonProperty(value="virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;

    public NetworkRuleBypassOptions bypass() {
        return this.bypass;
    }

    public NetworkRuleSet withBypass(NetworkRuleBypassOptions bypass) {
        this.bypass = bypass;
        return this;
    }

    public NetworkRuleAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(NetworkRuleAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public NetworkRuleSet withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public void validate() {
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
    }
}

