/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretItem;
import com.azure.security.keyvault.secrets.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SecretClientBuilder.class, isAsync=true, serviceInterfaces={SecretClientImpl.SecretClientService.class})
public final class SecretAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SecretAsyncClient.class);
    private final SecretClientImpl implClient;
    private final String vaultUrl;

    SecretAsyncClient(SecretClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> setSecret(KeyVaultSecret secret) {
        return this.setSecretWithResponse(secret).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> setSecret(String name, String value) {
        return this.setSecretWithResponse(new KeyVaultSecret(name, value)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> setSecretWithResponse(KeyVaultSecret secret) {
        try {
            SecretProperties secretProperties = secret.getProperties();
            if (secretProperties == null) {
                return this.implClient.setSecretWithResponseAsync(this.vaultUrl, secret.getName(), secret.getValue(), null, "application/json", null).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapSetSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue())));
            }
            return this.implClient.setSecretWithResponseAsync(this.vaultUrl, secret.getName(), secret.getValue(), secret.getProperties().getTags(), "application/json", SecretsModelsUtils.createSecretAttributes(secret.getProperties())).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapSetSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapSetSecretException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> getSecret(String name) {
        return this.getSecretWithResponse(name, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> getSecret(String name, String version) {
        return this.getSecretWithResponse(name, version).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> getSecretWithResponse(String name, String version) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        try {
            return this.implClient.getSecretWithResponseAsync(this.vaultUrl, name, version).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapGetSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapGetSecretException(HttpResponseException ex) {
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 403) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), ex.getValue());
        }
        return ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretProperties> updateSecretProperties(SecretProperties secretProperties) {
        return this.updateSecretPropertiesWithResponse(secretProperties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretProperties>> updateSecretPropertiesWithResponse(SecretProperties secretProperties) {
        try {
            return this.implClient.updateSecretWithResponseAsync(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), "application/json", SecretsModelsUtils.createSecretAttributes(secretProperties), secretProperties.getTags()).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createSecretProperties((SecretBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedSecret, Void> beginDeleteSecret(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedSecret>, Mono<DeletedSecret>> deleteActivationOperation(String name) {
        return pollingContext -> this.implClient.deleteSecretAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapDeleteSecretException).map(SecretsModelsUtils::createDeletedSecret);
    }

    static HttpResponseException mapDeleteSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    private Function<PollingContext<DeletedSecret>, Mono<PollResponse<DeletedSecret>>> deletePollOperation(String name) {
        return pollingContext -> this.implClient.getDeletedSecretAsync(this.vaultUrl, name).map(bundle -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createDeletedSecret(bundle))).onErrorResume(HttpResponseException.class, exception -> {
            if (exception.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecret> getDeletedSecret(String name) {
        return this.getDeletedSecretWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecret>> getDeletedSecretWithResponse(String name) {
        try {
            return this.implClient.getDeletedSecretWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapGetDeletedSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapGetDeletedSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecret(String name) {
        return this.purgeDeletedSecretWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponse(String name) {
        try {
            return this.implClient.purgeDeletedSecretWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapPurgeDeletedSecretException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapPurgeDeletedSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> this.implClient.recoverDeletedSecretAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapRecoverDeletedSecretException).map(SecretsModelsUtils::createKeyVaultSecret);
    }

    static HttpResponseException mapRecoverDeletedSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<PollResponse<KeyVaultSecret>>> recoverPollOperation(String name) {
        return pollingContext -> this.implClient.getSecretWithResponseAsync(this.vaultUrl, name, null).map(response -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue()))).onErrorResume(HttpResponseException.class, exception -> {
            if (exception.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupSecret(String name) {
        return this.backupSecretWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupSecretWithResponse(String name) {
        try {
            return this.implClient.backupSecretWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapBackupSecretException).map(response -> new SimpleResponse(response, (Object)((BackupSecretResult)response.getValue()).getValue()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapBackupSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSecret> restoreSecretBackup(byte[] backup) {
        return this.restoreSecretBackupWithResponse(backup).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSecret>> restoreSecretBackupWithResponse(byte[] backup) {
        try {
            return this.implClient.restoreSecretWithResponseAsync(this.vaultUrl, backup).onErrorMap(KeyVaultErrorException.class, SecretAsyncClient::mapRestoreSecretException).map(response -> new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    static HttpResponseException mapRestoreSecretException(HttpResponseException ex) {
        return ex.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(ex.getMessage(), ex.getResponse(), ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretProperties> listPropertiesOfSecrets() {
        return new PagedFlux(maxResults -> this.implClient.getSecretsSinglePageAsync(this.vaultUrl, (Integer)maxResults).map(SecretAsyncClient::mapSecretItemPage), (continuationToken, maxResults) -> this.implClient.getSecretsNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(SecretAsyncClient::mapSecretItemPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedSecret> listDeletedSecrets() {
        return new PagedFlux(maxResults -> this.implClient.getDeletedSecretsSinglePageAsync(this.vaultUrl, (Integer)maxResults).map(SecretAsyncClient::mapDeletedSecretItemPage), (continuationToken, maxResults) -> this.implClient.getDeletedSecretsNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(SecretAsyncClient::mapDeletedSecretItemPage));
    }

    static PagedResponse<DeletedSecret> mapDeletedSecretItemPage(PagedResponse<DeletedSecretItem> page) {
        ArrayList<DeletedSecret> converted = new ArrayList<DeletedSecret>(page.getValue().size());
        for (DeletedSecretItem deletedSecretItem : page.getValue()) {
            converted.add(SecretsModelsUtils.createDeletedSecret(deletedSecretItem));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), converted, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return new PagedFlux(maxResults -> this.implClient.getSecretVersionsSinglePageAsync(this.vaultUrl, name, (Integer)maxResults).map(SecretAsyncClient::mapSecretItemPage), (continuationToken, maxResults) -> this.implClient.getSecretVersionsNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(SecretAsyncClient::mapSecretItemPage));
    }

    static PagedResponse<SecretProperties> mapSecretItemPage(PagedResponse<SecretItem> page) {
        ArrayList<SecretProperties> converted = new ArrayList<SecretProperties>(page.getValue().size());
        for (SecretItem secretItem : page.getValue()) {
            converted.add(SecretsModelsUtils.createSecretProperties(secretItem));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), converted, (String)page.getContinuationToken(), null);
    }
}

