/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.BuilderHelper;
import com.azure.data.tables.EntityHelper;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.EntityPaged;
import com.azure.data.tables.implementation.TableEntityAccessHelper;
import com.azure.data.tables.implementation.TableItemAccessHelper;
import com.azure.data.tables.implementation.TableSasGenerator;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableTransactionActionResponseAccessHelper;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.implementation.TransactionalBatchImpl;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.implementation.models.TableServiceJsonError;
import com.azure.data.tables.implementation.models.TableSignedIdentifierWrapper;
import com.azure.data.tables.implementation.models.TablesQueryEntitiesHeaders;
import com.azure.data.tables.implementation.models.TransactionalBatchAction;
import com.azure.data.tables.implementation.models.TransactionalBatchChangeSet;
import com.azure.data.tables.implementation.models.TransactionalBatchRequestBody;
import com.azure.data.tables.implementation.models.TransactionalBatchSubRequest;
import com.azure.data.tables.implementation.models.TransactionalBatchSubmitBatchHeaders;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableAccessPolicies;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableEntityUpdateMode;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.data.tables.models.TableTransactionAction;
import com.azure.data.tables.models.TableTransactionActionResponse;
import com.azure.data.tables.models.TableTransactionFailedException;
import com.azure.data.tables.models.TableTransactionResult;
import com.azure.data.tables.sas.TableSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=TableClientBuilder.class, isAsync=true)
public final class TableAsyncClient {
    private final ClientLogger logger = new ClientLogger(TableAsyncClient.class);
    private final String tableName;
    private final AzureTableImpl tablesImplementation;
    private final TransactionalBatchImpl transactionalBatchImplementation;
    private final String accountName;
    private final String tableEndpoint;
    private final HttpPipeline pipeline;
    private final TableAsyncClient transactionalBatchClient;

    TableAsyncClient(String tableName, HttpPipeline pipeline, String serviceUrl, TableServiceVersion serviceVersion, SerializerAdapter tablesSerializer, SerializerAdapter transactionalBatchSerializer) {
        try {
            if (tableName == null) {
                throw new NullPointerException("'tableName' must not be null to create a TableClient.");
            }
            if (tableName.isEmpty()) {
                throw new IllegalArgumentException("'tableName' must not be empty to create a TableClient.");
            }
            URI uri = URI.create(serviceUrl);
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.tableEndpoint = uri.resolve("/" + tableName).toString();
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw this.logger.logExceptionAsError(ex);
        }
        this.tablesImplementation = new AzureTableImplBuilder().url(serviceUrl).serializerAdapter(tablesSerializer).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
        this.transactionalBatchImplementation = new TransactionalBatchImpl(this.tablesImplementation, transactionalBatchSerializer);
        this.tableName = tableName;
        this.pipeline = this.tablesImplementation.getHttpPipeline();
        this.transactionalBatchClient = new TableAsyncClient(this, serviceVersion, tablesSerializer);
    }

    TableAsyncClient(TableAsyncClient client, ServiceVersion serviceVersion, SerializerAdapter tablesSerializer) {
        this.accountName = client.getAccountName();
        this.tableEndpoint = client.getTableEndpoint();
        this.pipeline = BuilderHelper.buildNullClientPipeline();
        this.tablesImplementation = new AzureTableImplBuilder().url(client.getTablesImplementation().getUrl()).serializerAdapter(tablesSerializer).pipeline(this.pipeline).version(serviceVersion.getVersion()).buildClient();
        this.tableName = client.getTableName();
        this.transactionalBatchImplementation = null;
        this.transactionalBatchClient = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getTableEndpoint() {
        return this.tableEndpoint;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    AzureTableImpl getTablesImplementation() {
        return this.tablesImplementation;
    }

    public TableServiceVersion getServiceVersion() {
        return TableServiceVersion.fromString(this.tablesImplementation.getVersion());
    }

    public String generateSas(TableSasSignatureValues tableSasSignatureValues) {
        AzureNamedKeyCredential azureNamedKeyCredential = TableSasUtils.extractNamedKeyCredential(this.getHttpPipeline());
        if (azureNamedKeyCredential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot generate a SAS token with a client that is not authenticated with an AzureNamedKeyCredential."));
        }
        return new TableSasGenerator(tableSasSignatureValues, this.getTableName(), azureNamedKeyCredential).getSas();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableItem> createTable() {
        return this.createTableWithResponse().flatMap(response -> Mono.justOrEmpty((Object)((TableItem)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableItem>> createTableWithResponse() {
        return FluxUtil.withContext(this::createTableWithResponse);
    }

    Mono<Response<TableItem>> createTableWithResponse(Context context) {
        TableProperties properties = new TableProperties().setTableName(this.tableName);
        try {
            return this.tablesImplementation.getTables().createWithResponseAsync(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)TableItemAccessHelper.createItem(new TableResponseProperties().setTableName(this.tableName))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTable() {
        return this.deleteTableWithResponse().flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTableWithResponse() {
        return FluxUtil.withContext(this::deleteTableWithResponse);
    }

    Mono<Response<Void>> deleteTableWithResponse(Context context) {
        try {
            return this.tablesImplementation.getTables().deleteWithResponseAsync(this.tableName, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, null)).onErrorResume(TableServiceException.class, e -> TableUtils.swallowExceptionForStatusCode(404, e, this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createEntity(TableEntity entity) {
        return this.createEntityWithResponse(entity).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createEntityWithResponse(TableEntity entity) {
        return FluxUtil.withContext(context -> this.createEntityWithResponse(entity, (Context)context));
    }

    Mono<Response<Void>> createEntityWithResponse(TableEntity entity, Context context) {
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        try {
            return this.tablesImplementation.getTables().insertEntityWithResponseAsync(this.tableName, null, null, ResponseFormat.RETURN_NO_CONTENT, entity.getProperties(), null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> upsertEntity(TableEntity entity) {
        return this.upsertEntityWithResponse(entity, null).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> upsertEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode) {
        return FluxUtil.withContext(context -> this.upsertEntityWithResponse(entity, updateMode, (Context)context));
    }

    Mono<Response<Void>> upsertEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, Context context) {
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        String partitionKey = TableUtils.escapeSingleQuotes(entity.getPartitionKey());
        String rowKey = TableUtils.escapeSingleQuotes(entity.getRowKey());
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        try {
            if (updateMode == TableEntityUpdateMode.REPLACE) {
                return this.tablesImplementation.getTables().updateEntityWithResponseAsync(this.tableName, partitionKey, rowKey, null, null, null, entity.getProperties(), null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
            }
            return this.tablesImplementation.getTables().mergeEntityWithResponseAsync(this.tableName, partitionKey, rowKey, null, null, null, entity.getProperties(), null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateEntity(TableEntity entity) {
        return this.updateEntity(entity, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateEntity(TableEntity entity, TableEntityUpdateMode updateMode) {
        return this.updateEntityWithResponse(entity, updateMode, false).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, boolean ifUnchanged) {
        return FluxUtil.withContext(context -> this.updateEntityWithResponse(entity, updateMode, ifUnchanged, (Context)context));
    }

    Mono<Response<Void>> updateEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, boolean ifUnchanged, Context context) {
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'entity' cannot be null."));
        }
        String partitionKey = TableUtils.escapeSingleQuotes(entity.getPartitionKey());
        String rowKey = TableUtils.escapeSingleQuotes(entity.getRowKey());
        String eTag = ifUnchanged ? entity.getETag() : "*";
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        try {
            if (updateMode == TableEntityUpdateMode.REPLACE) {
                return this.tablesImplementation.getTables().updateEntityWithResponseAsync(this.tableName, partitionKey, rowKey, null, null, eTag, entity.getProperties(), null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
            }
            return this.tablesImplementation.getTables().mergeEntityWithResponseAsync(this.tableName, partitionKey, rowKey, null, null, eTag, entity.getProperties(), null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEntity(String partitionKey, String rowKey) {
        return this.deleteEntityWithResponse(partitionKey, rowKey, null, false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEntity(TableEntity entity) {
        return this.deleteEntityWithResponse(entity, false).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteEntityWithResponse(TableEntity entity, boolean ifUnchanged) {
        return FluxUtil.withContext(context -> this.deleteEntityWithResponse(entity.getPartitionKey(), entity.getRowKey(), entity.getETag(), ifUnchanged, (Context)context));
    }

    Mono<Response<Void>> deleteEntityWithResponse(String partitionKey, String rowKey, String eTag, boolean ifUnchanged, Context context) {
        String string = eTag = ifUnchanged ? eTag : "*";
        if (partitionKey == null || rowKey == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'partitionKey' and 'rowKey' cannot be null."));
        }
        try {
            return this.tablesImplementation.getTables().deleteEntityWithResponseAsync(this.tableName, TableUtils.escapeSingleQuotes(partitionKey), TableUtils.escapeSingleQuotes(rowKey), eTag, null, null, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, null)).onErrorResume(TableServiceException.class, e -> TableUtils.swallowExceptionForStatusCode(404, e, this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TableEntity> listEntities() {
        return this.listEntities(new ListEntitiesOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TableEntity> listEntities(ListEntitiesOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listEntitiesFirstPage((Context)context, options, (Class)TableEntity.class)), token -> FluxUtil.withContext(context -> this.listEntitiesNextPage((String)token, (Context)context, options, (Class)TableEntity.class)));
    }

    PagedFlux<TableEntity> listEntities(ListEntitiesOptions options, Context context, Duration timeout) {
        return new PagedFlux(() -> TableUtils.applyOptionalTimeout(this.listEntitiesFirstPage(context, options, TableEntity.class), timeout), token -> TableUtils.applyOptionalTimeout(this.listEntitiesNextPage((String)token, context, options, (Class)TableEntity.class), timeout));
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntitiesFirstPage(Context context, ListEntitiesOptions options, Class<T> resultType) {
        return this.listEntities(null, null, context, options, resultType);
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntitiesNextPage(String token, Context context, ListEntitiesOptions options, Class<T> resultType) {
        if (token == null) {
            return Mono.empty();
        }
        try {
            String[] split = TableUtils.getKeysFromToken(token);
            return this.listEntities(split[0], split[1], context, options, resultType);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntities(String nextPartitionKey, String nextRowKey, Context context, ListEntitiesOptions options, Class<T> resultType) {
        String select = null;
        if (options.getSelect() != null) {
            select = String.join((CharSequence)",", options.getSelect());
        }
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setSelect(select).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        try {
            return this.tablesImplementation.getTables().queryEntitiesWithResponseAsync(this.tableName, null, null, nextPartitionKey, nextRowKey, queryOptions, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).flatMap(response -> {
                TableEntityQueryResponse tablesQueryEntityResponse = (TableEntityQueryResponse)response.getValue();
                if (tablesQueryEntityResponse == null) {
                    return Mono.empty();
                }
                List<Map<String, Object>> entityResponseValue = tablesQueryEntityResponse.getValue();
                if (entityResponseValue == null) {
                    return Mono.empty();
                }
                List entities = entityResponseValue.stream().map(TableEntityAccessHelper::createEntity).map(e -> EntityHelper.convertToSubclass(e, resultType, this.logger)).collect(Collectors.toList());
                return Mono.just(new EntityPaged((Response<TableEntityQueryResponse>)response, entities, ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextPartitionKey(), ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextRowKey()));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableEntity> getEntity(String partitionKey, String rowKey) {
        return this.getEntityWithResponse(partitionKey, rowKey, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableEntity>> getEntityWithResponse(String partitionKey, String rowKey, List<String> select) {
        return FluxUtil.withContext(context -> this.getEntityWithResponse(partitionKey, rowKey, select, (Class)TableEntity.class, (Context)context));
    }

    <T extends TableEntity> Mono<Response<T>> getEntityWithResponse(String partitionKey, String rowKey, List<String> select, Class<T> resultType, Context context) {
        QueryOptions queryOptions = new QueryOptions().setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        if (select != null) {
            queryOptions.setSelect(String.join((CharSequence)",", select));
        }
        if (partitionKey == null || rowKey == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'partitionKey' and 'rowKey' cannot be null."));
        }
        try {
            return this.tablesImplementation.getTables().queryEntityWithPartitionAndRowKeyWithResponseAsync(this.tableName, TableUtils.escapeSingleQuotes(partitionKey), TableUtils.escapeSingleQuotes(rowKey), null, null, queryOptions, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).handle((response, sink) -> {
                Map matchingEntity = (Map)response.getValue();
                if (matchingEntity == null || matchingEntity.isEmpty()) {
                    this.logger.info("There was no matching entity. Table: {}, partition key: {}, row key: {}.", new Object[]{this.tableName, partitionKey, rowKey});
                    sink.complete();
                    return;
                }
                TableEntity entity = TableEntityAccessHelper.createEntity(matchingEntity);
                sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), EntityHelper.convertToSubclass(entity, resultType, this.logger)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableAccessPolicies> getAccessPolicies() {
        return FluxUtil.withContext(context -> this.getAccessPoliciesWithResponse((Context)context).flatMap(response -> Mono.justOrEmpty((Object)((TableAccessPolicies)response.getValue()))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableAccessPolicies>> getAccessPoliciesWithResponse() {
        return FluxUtil.withContext(this::getAccessPoliciesWithResponse);
    }

    Mono<Response<TableAccessPolicies>> getAccessPoliciesWithResponse(Context context) {
        try {
            return this.tablesImplementation.getTables().getAccessPolicyWithResponseAsync(this.tableName, null, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)new TableAccessPolicies(response.getValue() == null ? null : ((TableSignedIdentifierWrapper)response.getValue()).items())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicies(List<TableSignedIdentifier> tableSignedIdentifiers) {
        return this.setAccessPoliciesWithResponse(tableSignedIdentifiers).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPoliciesWithResponse(List<TableSignedIdentifier> tableSignedIdentifiers) {
        return FluxUtil.withContext(context -> this.setAccessPoliciesWithResponse(tableSignedIdentifiers, (Context)context));
    }

    Mono<Response<Void>> setAccessPoliciesWithResponse(List<TableSignedIdentifier> tableSignedIdentifiers, Context context) {
        if (tableSignedIdentifiers != null) {
            for (TableSignedIdentifier signedIdentifier : tableSignedIdentifiers) {
                if (signedIdentifier == null || signedIdentifier.getAccessPolicy() == null) continue;
                if (signedIdentifier.getAccessPolicy().getStartsOn() != null) {
                    signedIdentifier.getAccessPolicy().setStartsOn(signedIdentifier.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (signedIdentifier.getAccessPolicy().getExpiresOn() == null) continue;
                signedIdentifier.getAccessPolicy().setExpiresOn(signedIdentifier.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        try {
            return this.tablesImplementation.getTables().setAccessPolicyWithResponseAsync(this.tableName, null, null, tableSignedIdentifiers, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)((Void)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableTransactionResult> submitTransaction(List<TableTransactionAction> transactionActions) {
        return this.submitTransactionWithResponse(transactionActions).flatMap(response -> Mono.justOrEmpty((Object)((TableTransactionResult)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableTransactionResult>> submitTransactionWithResponse(List<TableTransactionAction> transactionActions) {
        return FluxUtil.withContext(context -> this.submitTransactionWithResponse(transactionActions, (Context)context));
    }

    Mono<Response<TableTransactionResult>> submitTransactionWithResponse(List<TableTransactionAction> transactionActions, Context context) {
        if (transactionActions.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("A transaction must contain at least one operation."));
        }
        ArrayList<TransactionalBatchAction> operations = new ArrayList<TransactionalBatchAction>();
        for (TableTransactionAction transactionAction : transactionActions) {
            switch (transactionAction.getActionType()) {
                case CREATE: {
                    operations.add(new TransactionalBatchAction.CreateEntity(transactionAction.getEntity()));
                    break;
                }
                case UPSERT_MERGE: {
                    operations.add(new TransactionalBatchAction.UpsertEntity(transactionAction.getEntity(), TableEntityUpdateMode.MERGE));
                    break;
                }
                case UPSERT_REPLACE: {
                    operations.add(new TransactionalBatchAction.UpsertEntity(transactionAction.getEntity(), TableEntityUpdateMode.REPLACE));
                    break;
                }
                case UPDATE_MERGE: {
                    operations.add(new TransactionalBatchAction.UpdateEntity(transactionAction.getEntity(), TableEntityUpdateMode.MERGE, transactionAction.getIfUnchanged()));
                    break;
                }
                case UPDATE_REPLACE: {
                    operations.add(new TransactionalBatchAction.UpdateEntity(transactionAction.getEntity(), TableEntityUpdateMode.REPLACE, transactionAction.getIfUnchanged()));
                    break;
                }
                case DELETE: {
                    operations.add(new TransactionalBatchAction.DeleteEntity(transactionAction.getEntity(), transactionAction.getIfUnchanged()));
                    break;
                }
            }
        }
        try {
            return Flux.fromIterable(operations).flatMapSequential(op -> op.prepareRequest(this.transactionalBatchClient).zipWith(Mono.just((Object)op))).collect(TransactionalBatchRequestBody::new, (body, pair) -> body.addChangeOperation(new TransactionalBatchSubRequest((TransactionalBatchAction)pair.getT2(), (HttpRequest)pair.getT1()))).publishOn(Schedulers.boundedElastic()).flatMap(body -> this.transactionalBatchImplementation.submitTransactionalBatchWithRestResponseAsync((TransactionalBatchRequestBody)body, null, context).zipWith(Mono.just((Object)body))).onErrorMap(TableUtils::mapThrowableToTableServiceException).flatMap(pair -> this.parseResponse((TransactionalBatchRequestBody)pair.getT2(), (ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]>)((ResponseBase)pair.getT1()))).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new TableTransactionResult(transactionActions, (List)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private Mono<Response<List<TableTransactionActionResponse>>> parseResponse(TransactionalBatchRequestBody requestBody, ResponseBase<TransactionalBatchSubmitBatchHeaders, TableTransactionActionResponse[]> response) {
        TableServiceJsonError error = null;
        String errorMessage = null;
        TransactionalBatchChangeSet changes = null;
        TransactionalBatchAction failedAction = null;
        Integer failedIndex = null;
        if (requestBody.getContents().get(0) instanceof TransactionalBatchChangeSet) {
            changes = (TransactionalBatchChangeSet)requestBody.getContents().get(0);
        }
        for (int i = 0; i < ((TableTransactionActionResponse[])response.getValue()).length; ++i) {
            TableTransactionActionResponse subResponse = ((TableTransactionActionResponse[])response.getValue())[i];
            if (changes != null && changes.getContents().get(i) != null) {
                TableTransactionActionResponseAccessHelper.updateTableTransactionActionResponse(subResponse, ((TransactionalBatchSubRequest)changes.getContents().get(i)).getHttpRequest());
            }
            if (subResponse.getStatusCode() < 400 || error != null || errorMessage != null) continue;
            if (subResponse.getValue() instanceof TableServiceJsonError) {
                error = (TableServiceJsonError)subResponse.getValue();
                if (changes == null || error.getOdataError() == null || error.getOdataError().getMessage() == null || error.getOdataError().getMessage().getValue() == null) continue;
                String message = error.getOdataError().getMessage().getValue();
                try {
                    failedIndex = Integer.parseInt(message.substring(0, message.indexOf(":")));
                    failedAction = ((TransactionalBatchSubRequest)changes.getContents().get(failedIndex)).getOperation();
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            errorMessage = subResponse.getValue() instanceof String ? "The service returned the following data for the failed operation: " + subResponse.getValue() : "The service returned the following status code for the failed operation: " + subResponse.getStatusCode();
        }
        if (error != null || errorMessage != null) {
            String message = "An action within the operation failed, the transaction has been rolled back.";
            if (failedAction != null) {
                message = message + " The failed operation was: " + failedAction;
            } else if (errorMessage != null) {
                message = message + " " + errorMessage;
            }
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)new TableTransactionFailedException(message, null, TableUtils.toTableServiceError(error), failedIndex)));
        }
        return Mono.just((Object)new SimpleResponse(response, Arrays.asList((TableTransactionActionResponse[])response.getValue())));
    }
}

