/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableServiceRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceMetrics
implements XmlSerializable<TableServiceMetrics> {
    private String version;
    private boolean enabled;
    private Boolean includeApis;
    private TableServiceRetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public TableServiceMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TableServiceMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    public TableServiceMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    public TableServiceRetentionPolicy getTableServiceRetentionPolicy() {
        return this.retentionPolicy;
    }

    public TableServiceMetrics setRetentionPolicy(TableServiceRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "TableServiceMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static TableServiceMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceMetrics.fromXml(xmlReader, null);
    }

    public static TableServiceMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "TableServiceMetrics" : rootElementName;
        return (TableServiceMetrics)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceMetrics deserializedTableServiceMetrics = new TableServiceMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.version = reader.getStringElement();
                    continue;
                }
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.includeApis = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.retentionPolicy = TableServiceRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceMetrics;
        });
    }
}

