// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.data.tables.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A signed identifier.
 */
@Fluent
public final class TableSignedIdentifier implements XmlSerializable<TableSignedIdentifier> {

    /*
     * A unique id.
     */
    private String id;

    /*
     * The access policy.
     */
    private TableAccessPolicy accessPolicy;

    /**
     * Creates an instance of TableSignedIdentifier class.
     *
     * @param id A unique id for this {@link TableSignedIdentifier}.
     * @throws NullPointerException If {@code id} is null.
     */
    public TableSignedIdentifier(String id) {
        this.id = Objects.requireNonNull(id, "'id' cannot be null");
    }

    /**
     * Get the id property: A unique id.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the accessPolicy property: The access policy.
     *
     * @return the accessPolicy value.
     */
    public TableAccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    /**
     * Set the accessPolicy property: The access policy.
     *
     * @param accessPolicy the accessPolicy value to set.
     * @return the TableSignedIdentifier object itself.
     */
    public TableSignedIdentifier setAccessPolicy(TableAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Id", this.id);
        xmlWriter.writeXml(this.accessPolicy, "AccessPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableSignedIdentifier from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableSignedIdentifier.
     */
    public static TableSignedIdentifier fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableSignedIdentifier from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableSignedIdentifier.
     */
    public static TableSignedIdentifier fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableSignedIdentifier deserializedTableSignedIdentifier = new TableSignedIdentifier();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Id".equals(elementName.getLocalPart())) {
                    deserializedTableSignedIdentifier.id = reader.getStringElement();
                } else if ("AccessPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableSignedIdentifier.accessPolicy = TableAccessPolicy.fromXml(reader, "AccessPolicy");
                } else {
                    reader.skipElement();
                }
            }
            return deserializedTableSignedIdentifier;
        });
    }

    private TableSignedIdentifier() {
    }
}
