/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka;

import com.arturmkrtchyan.kafka.AbstractKafkaMojo;
import com.arturmkrtchyan.kafka.KafkaDownloader;
import com.arturmkrtchyan.kafka.KafkaFileSystemHelper;
import com.arturmkrtchyan.kafka.KafkaInstance;
import com.arturmkrtchyan.kafka.KafkaPluginException;
import com.arturmkrtchyan.kafka.util.TarUnpacker;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class KafkaStartMojo
extends AbstractKafkaMojo {
    private KafkaDownloader kafkaDownloader = new KafkaDownloader();
    private TarUnpacker tarUnpacker = new TarUnpacker();

    public void execute() throws MojoExecutionException {
        this.downloadKafka();
        KafkaInstance instance = this.createKafkaInstance();
        this.getKafkaManager().startZookeeper(instance);
        this.getKafkaManager().startKafka(instance);
    }

    protected KafkaInstance createKafkaInstance() {
        Path artifactPath = KafkaFileSystemHelper.artifactPath(this.getScalaVersion(), this.getKafkaVersion());
        Path instanceDir = KafkaFileSystemHelper.instanceDir(this.getBuildDir());
        try {
            this.debug(String.format("Unpacking kafka from %s into %s", artifactPath, instanceDir));
            this.tarUnpacker.unpack(artifactPath, instanceDir, true);
        }
        catch (IOException e) {
            throw new KafkaPluginException(String.format("Unable to unpack kafka from %s into %s", artifactPath, instanceDir), e);
        }
        return KafkaInstance.fromPath(instanceDir.resolve(KafkaFileSystemHelper.instanceName(this.getScalaVersion(), this.getKafkaVersion())));
    }

    protected void downloadKafka() {
        String artifactName = KafkaFileSystemHelper.artifactName(this.getScalaVersion(), this.getKafkaVersion());
        this.debug(String.format("Checking if %s is already downloaded into %s", artifactName, KafkaFileSystemHelper.KAFKA_ARTIFACT_DIR));
        if (!this.kafkaDownloader.isDownloaded(KafkaFileSystemHelper.artifactPath(this.getScalaVersion(), this.getKafkaVersion()))) {
            this.getLog().info((CharSequence)this.getDottedString());
            this.getLog().info((CharSequence)String.format("Downloading %s into %s", artifactName, KafkaFileSystemHelper.KAFKA_ARTIFACT_DIR));
            this.getLog().info((CharSequence)this.getDottedString());
            this.kafkaDownloader.download(Paths.get(KafkaFileSystemHelper.KAFKA_ARTIFACT_DIR, new String[0]), this.getScalaVersion(), this.getKafkaVersion());
        } else {
            this.debug(String.format("%s is already downloaded into %s", artifactName, KafkaFileSystemHelper.KAFKA_ARTIFACT_DIR));
        }
    }
}

