/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Cast;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.InlineIfExpression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class JavaScriptInterfaceDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"JavascriptInterface", (String)"Missing @JavascriptInterface on methods", (String)"As of API 17, you must annotate methods in objects registered with the `addJavascriptInterface` method with a `@JavascriptInterface` annotation.", (Category)Category.SECURITY, (int)8, (Severity)Severity.ERROR, (Implementation)new Implementation(JavaScriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)");
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation call) {
        Node method;
        if (context.getMainProject().getTargetSdk() < 17) {
            return;
        }
        if (call.astArguments().size() != 2) {
            return;
        }
        if (!JavaScriptInterfaceDetector.isCallOnWebView(context, call)) {
            return;
        }
        Expression first = (Expression)call.astArguments().first();
        JavaParser.ResolvedNode resolved = context.resolve((Node)first);
        if (resolved instanceof JavaParser.ResolvedVariable) {
            method = JavaContext.findSurroundingMethod((Node)call);
            if (method == null) return;
            ConcreteTypeVisitor v = new ConcreteTypeVisitor(context, call);
            method.accept((AstVisitor)v);
            resolved = v.getType();
            if (resolved == null) {
                return;
            }
        } else if (resolved instanceof JavaParser.ResolvedMethod) {
            method = (JavaParser.ResolvedMethod)resolved;
            if (method.isConstructor()) {
                resolved = method.getContainingClass();
            } else {
                JavaParser.TypeDescriptor returnType = method.getReturnType();
                if (returnType != null) {
                    resolved = returnType.getTypeClass();
                }
            }
        } else {
            JavaParser.TypeDescriptor type = context.getType((Node)first);
            if (type != null) {
                resolved = type.getTypeClass();
            }
        }
        if (!(resolved instanceof JavaParser.ResolvedClass)) return;
        JavaParser.ResolvedClass cls = (JavaParser.ResolvedClass)resolved;
        if (JavaScriptInterfaceDetector.isJavaScriptAnnotated(cls)) {
            return;
        }
        Location location = context.getLocation((Node)call.astName());
        String message = String.format("None of the methods in the added interface (%1$s) have been annotated with `@android.webkit.JavascriptInterface`; they will not be visible in API 17", cls.getSimpleName());
        context.report(ISSUE, (Node)call, location, message);
    }

    private static boolean isCallOnWebView(JavaContext context, MethodInvocation call) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return false;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        return method.getContainingClass().matches(WEB_VIEW_CLS);
    }

    private static boolean isJavaScriptAnnotated(JavaParser.ResolvedClass clz) {
        while (clz != null) {
            for (JavaParser.ResolvedAnnotation annotation : clz.getAnnotations()) {
                if (!annotation.getType().matchesSignature(JAVASCRIPT_INTERFACE_CLS)) continue;
                return true;
            }
            for (JavaParser.ResolvedMethod method : clz.getMethods(false)) {
                for (JavaParser.ResolvedAnnotation annotation : method.getAnnotations()) {
                    if (!annotation.getType().matchesSignature(JAVASCRIPT_INTERFACE_CLS)) continue;
                    return true;
                }
            }
            clz = clz.getSuperClass();
        }
        return false;
    }

    private static class ConcreteTypeVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private final MethodInvocation mTargetCall;
        private boolean mFoundCall;
        private Map<Node, JavaParser.ResolvedClass> mTypes = Maps.newIdentityHashMap();
        private Map<JavaParser.ResolvedVariable, JavaParser.ResolvedClass> mVariableTypes = Maps.newHashMap();

        public ConcreteTypeVisitor(JavaContext context, MethodInvocation call) {
            this.mContext = context;
            this.mTargetCall = call;
        }

        public JavaParser.ResolvedClass getType() {
            JavaParser.ResolvedNode resolved;
            Expression first = (Expression)this.mTargetCall.astArguments().first();
            JavaParser.ResolvedClass resolvedClass = this.mTypes.get(first);
            if (resolvedClass == null && (resolved = this.mContext.resolve((Node)first)) instanceof JavaParser.ResolvedVariable && (resolvedClass = this.mVariableTypes.get(resolved)) == null) {
                return ((JavaParser.ResolvedVariable)resolved).getType().getTypeClass();
            }
            return resolvedClass;
        }

        public boolean visitNode(Node node) {
            return this.mFoundCall || super.visitNode(node);
        }

        public void afterVisitMethodInvocation(MethodInvocation node) {
            if (node == this.mTargetCall) {
                this.mFoundCall = true;
            }
        }

        public void afterVisitConstructorInvocation(@NonNull ConstructorInvocation node) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
            if (resolved instanceof JavaParser.ResolvedMethod) {
                JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                this.mTypes.put((Node)node, method.getContainingClass());
            } else {
                JavaParser.ResolvedClass typeClass;
                JavaParser.TypeDescriptor type = this.mContext.getType((Node)node);
                if (type != null && (typeClass = type.getTypeClass()) != null) {
                    this.mTypes.put((Node)node, typeClass);
                }
            }
        }

        public void afterVisitVariableReference(VariableReference node) {
            JavaParser.ResolvedClass resolvedClass;
            JavaParser.ResolvedNode resolved;
            if (this.mTypes.get(node) == null && (resolved = this.mContext.resolve((Node)node)) instanceof JavaParser.ResolvedVariable && (resolvedClass = this.mVariableTypes.get(resolved)) != null) {
                this.mTypes.put((Node)node, resolvedClass);
            }
        }

        public void afterVisitBinaryExpression(BinaryExpression node) {
            Expression rhs;
            JavaParser.ResolvedClass resolvedClass;
            if (node.astOperator() == BinaryOperator.ASSIGN && (resolvedClass = this.mTypes.get(rhs = node.astRight())) != null) {
                Expression lhs = node.astLeft();
                this.mTypes.put((Node)lhs, resolvedClass);
                JavaParser.ResolvedNode variable = this.mContext.resolve((Node)lhs);
                if (variable instanceof JavaParser.ResolvedVariable) {
                    this.mVariableTypes.put((JavaParser.ResolvedVariable)variable, resolvedClass);
                }
            }
        }

        public void afterVisitInlineIfExpression(InlineIfExpression node) {
            JavaParser.ResolvedClass resolvedClass = this.mTypes.get(node.astIfTrue());
            if (resolvedClass == null) {
                resolvedClass = this.mTypes.get(node.astIfFalse());
            }
            if (resolvedClass != null) {
                this.mTypes.put((Node)node, resolvedClass);
            }
        }

        public void afterVisitVariableDefinitionEntry(VariableDefinitionEntry node) {
            JavaParser.ResolvedClass resolvedClass;
            Expression initializer = node.astInitializer();
            if (initializer != null && (resolvedClass = this.mTypes.get(initializer)) != null) {
                this.mTypes.put((Node)node, resolvedClass);
                JavaParser.ResolvedNode variable = this.mContext.resolve((Node)node);
                if (variable instanceof JavaParser.ResolvedVariable) {
                    this.mVariableTypes.put((JavaParser.ResolvedVariable)variable, resolvedClass);
                }
            }
        }

        public void afterVisitCast(Cast node) {
            JavaParser.ResolvedClass resolvedClass = this.mTypes.get(node);
            if (resolvedClass != null) {
                this.mTypes.put((Node)node, resolvedClass);
            }
        }
    }
}

