/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Super;

public class CallSuperDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"MissingSuperCall", (String)"Missing Super Call", (String)"Looks for overriding methods that should also invoke the parent method", (String)"Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(MethodDeclaration.class);
    }

    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new PerformanceVisitor(context);
    }

    private static class PerformanceVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public PerformanceVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            if (node.astMethodName().astValue().equals(CallSuperDetector.ON_DETACHED_FROM_WINDOW) && node.astParameters() != null && node.astParameters().isEmpty() && !this.callsSuper(node, CallSuperDetector.ON_DETACHED_FROM_WINDOW)) {
                boolean isView = true;
                JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
                if (resolved instanceof JavaParser.ResolvedMethod) {
                    JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                    isView = method.getContainingClass().isSubclassOf("android.view.View", false);
                }
                if (isView) {
                    String message = "Overriding method should call super.onDetachedFromWindow";
                    Location location = this.mContext.getLocation((Node)node.astMethodName());
                    this.mContext.report(ISSUE, (Node)node, location, message, null);
                }
            }
            return super.visitMethodDeclaration(node);
        }

        private boolean callsSuper(MethodDeclaration node, final String methodName) {
            final AtomicBoolean result = new AtomicBoolean();
            node.accept((AstVisitor)new ForwardingAstVisitor(){

                public boolean visitMethodInvocation(MethodInvocation node) {
                    if (node.astName().astValue().equals(methodName) && node.astOperand() instanceof Super) {
                        result.set(true);
                    }
                    return super.visitMethodInvocation(node);
                }
            });
            return result.get();
        }
    }
}

