/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class HandlerDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"HandlerLeak", (String)"Handler reference leaks", (String)"Ensures that Handler classes do not hold on to a reference to an outer class", (String)"Since this Handler is declared as an inner class, it may prevent the outer class from being garbage collected. If the Handler is using a Looper or MessageQueue for a thread other than the main thread, then there is no issue. If the Handler is using the Looper or MessageQueue of the main thread, you need to fix your Handler declaration, as follows: Declare the Handler as a static class; In the outer class, instantiate a WeakReference to the outer class and pass this object to your Handler when you instantiate the Handler; Make all references to members of the outer class using the WeakReference object.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)new Implementation(HandlerDetector.class, Scope.CLASS_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (classNode.name.indexOf(36) == -1) {
            return;
        }
        if (context.getDriver().isSubclassOf(classNode, "android/os/Handler") && !LintUtils.isStaticInnerClass((ClassNode)classNode)) {
            for (Object m : classNode.methods) {
                MethodNode method = (MethodNode)m;
                if (!"<init>".equals(method.name) || !method.desc.contains("Landroid/os/Looper;")) continue;
                return;
            }
            Location location = context.getLocation(classNode);
            context.report(ISSUE, location, String.format("This Handler class should be static or leaks might occur (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
        }
    }
}

