/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmailmessageflow.model.transform;

import com.amazonaws.services.workmailmessageflow.model.S3Reference;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ReferenceJsonUnmarshaller
implements Unmarshaller<S3Reference, JsonUnmarshallerContext> {
    private static S3ReferenceJsonUnmarshaller instance;

    public S3Reference unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Reference s3Reference = new S3Reference();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucket", targetDepth)) {
                    context.nextToken();
                    s3Reference.setBucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3Reference.setKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("objectVersion", targetDepth)) {
                    context.nextToken();
                    s3Reference.setObjectVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Reference;
    }

    public static S3ReferenceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ReferenceJsonUnmarshaller();
        }
        return instance;
    }
}

