/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.ForwardedIPConfig;
import com.amazonaws.services.wafv2.model.RateBasedStatementAggregateKeyType;
import com.amazonaws.services.wafv2.model.RateBasedStatementCustomKey;
import com.amazonaws.services.wafv2.model.Statement;
import com.amazonaws.services.wafv2.model.transform.RateBasedStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RateBasedStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private Long limit;
    private Long evaluationWindowSec;
    private String aggregateKeyType;
    private Statement scopeDownStatement;
    private ForwardedIPConfig forwardedIPConfig;
    private List<RateBasedStatementCustomKey> customKeys;

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getLimit() {
        return this.limit;
    }

    public RateBasedStatement withLimit(Long limit) {
        this.setLimit(limit);
        return this;
    }

    public void setEvaluationWindowSec(Long evaluationWindowSec) {
        this.evaluationWindowSec = evaluationWindowSec;
    }

    public Long getEvaluationWindowSec() {
        return this.evaluationWindowSec;
    }

    public RateBasedStatement withEvaluationWindowSec(Long evaluationWindowSec) {
        this.setEvaluationWindowSec(evaluationWindowSec);
        return this;
    }

    public void setAggregateKeyType(String aggregateKeyType) {
        this.aggregateKeyType = aggregateKeyType;
    }

    public String getAggregateKeyType() {
        return this.aggregateKeyType;
    }

    public RateBasedStatement withAggregateKeyType(String aggregateKeyType) {
        this.setAggregateKeyType(aggregateKeyType);
        return this;
    }

    public RateBasedStatement withAggregateKeyType(RateBasedStatementAggregateKeyType aggregateKeyType) {
        this.aggregateKeyType = aggregateKeyType.toString();
        return this;
    }

    public void setScopeDownStatement(Statement scopeDownStatement) {
        this.scopeDownStatement = scopeDownStatement;
    }

    public Statement getScopeDownStatement() {
        return this.scopeDownStatement;
    }

    public RateBasedStatement withScopeDownStatement(Statement scopeDownStatement) {
        this.setScopeDownStatement(scopeDownStatement);
        return this;
    }

    public void setForwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
        this.forwardedIPConfig = forwardedIPConfig;
    }

    public ForwardedIPConfig getForwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public RateBasedStatement withForwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
        this.setForwardedIPConfig(forwardedIPConfig);
        return this;
    }

    public List<RateBasedStatementCustomKey> getCustomKeys() {
        return this.customKeys;
    }

    public void setCustomKeys(Collection<RateBasedStatementCustomKey> customKeys) {
        if (customKeys == null) {
            this.customKeys = null;
            return;
        }
        this.customKeys = new ArrayList<RateBasedStatementCustomKey>(customKeys);
    }

    public RateBasedStatement withCustomKeys(RateBasedStatementCustomKey ... customKeys) {
        if (this.customKeys == null) {
            this.setCustomKeys(new ArrayList<RateBasedStatementCustomKey>(customKeys.length));
        }
        for (RateBasedStatementCustomKey ele : customKeys) {
            this.customKeys.add(ele);
        }
        return this;
    }

    public RateBasedStatement withCustomKeys(Collection<RateBasedStatementCustomKey> customKeys) {
        this.setCustomKeys(customKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getEvaluationWindowSec() != null) {
            sb.append("EvaluationWindowSec: ").append(this.getEvaluationWindowSec()).append(",");
        }
        if (this.getAggregateKeyType() != null) {
            sb.append("AggregateKeyType: ").append(this.getAggregateKeyType()).append(",");
        }
        if (this.getScopeDownStatement() != null) {
            sb.append("ScopeDownStatement: ").append(this.getScopeDownStatement()).append(",");
        }
        if (this.getForwardedIPConfig() != null) {
            sb.append("ForwardedIPConfig: ").append(this.getForwardedIPConfig()).append(",");
        }
        if (this.getCustomKeys() != null) {
            sb.append("CustomKeys: ").append(this.getCustomKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatement)) {
            return false;
        }
        RateBasedStatement other = (RateBasedStatement)obj;
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getEvaluationWindowSec() == null ^ this.getEvaluationWindowSec() == null) {
            return false;
        }
        if (other.getEvaluationWindowSec() != null && !other.getEvaluationWindowSec().equals(this.getEvaluationWindowSec())) {
            return false;
        }
        if (other.getAggregateKeyType() == null ^ this.getAggregateKeyType() == null) {
            return false;
        }
        if (other.getAggregateKeyType() != null && !other.getAggregateKeyType().equals(this.getAggregateKeyType())) {
            return false;
        }
        if (other.getScopeDownStatement() == null ^ this.getScopeDownStatement() == null) {
            return false;
        }
        if (other.getScopeDownStatement() != null && !other.getScopeDownStatement().equals(this.getScopeDownStatement())) {
            return false;
        }
        if (other.getForwardedIPConfig() == null ^ this.getForwardedIPConfig() == null) {
            return false;
        }
        if (other.getForwardedIPConfig() != null && !other.getForwardedIPConfig().equals(this.getForwardedIPConfig())) {
            return false;
        }
        if (other.getCustomKeys() == null ^ this.getCustomKeys() == null) {
            return false;
        }
        return other.getCustomKeys() == null || other.getCustomKeys().equals(this.getCustomKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationWindowSec() == null ? 0 : this.getEvaluationWindowSec().hashCode());
        hashCode = 31 * hashCode + (this.getAggregateKeyType() == null ? 0 : this.getAggregateKeyType().hashCode());
        hashCode = 31 * hashCode + (this.getScopeDownStatement() == null ? 0 : this.getScopeDownStatement().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedIPConfig() == null ? 0 : this.getForwardedIPConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCustomKeys() == null ? 0 : this.getCustomKeys().hashCode());
        return hashCode;
    }

    public RateBasedStatement clone() {
        try {
            return (RateBasedStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RateBasedStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

