/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteAsync;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteAsyncClientBuilder;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteClient;
import com.amazonaws.services.timestreamwrite.model.CreateDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.CreateDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.CreateTableRequest;
import com.amazonaws.services.timestreamwrite.model.CreateTableResult;
import com.amazonaws.services.timestreamwrite.model.DeleteDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.DeleteDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.DeleteTableRequest;
import com.amazonaws.services.timestreamwrite.model.DeleteTableResult;
import com.amazonaws.services.timestreamwrite.model.DescribeDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamwrite.model.DescribeTableRequest;
import com.amazonaws.services.timestreamwrite.model.DescribeTableResult;
import com.amazonaws.services.timestreamwrite.model.ListDatabasesRequest;
import com.amazonaws.services.timestreamwrite.model.ListDatabasesResult;
import com.amazonaws.services.timestreamwrite.model.ListTablesRequest;
import com.amazonaws.services.timestreamwrite.model.ListTablesResult;
import com.amazonaws.services.timestreamwrite.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreamwrite.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreamwrite.model.TagResourceRequest;
import com.amazonaws.services.timestreamwrite.model.TagResourceResult;
import com.amazonaws.services.timestreamwrite.model.UntagResourceRequest;
import com.amazonaws.services.timestreamwrite.model.UntagResourceResult;
import com.amazonaws.services.timestreamwrite.model.UpdateDatabaseRequest;
import com.amazonaws.services.timestreamwrite.model.UpdateDatabaseResult;
import com.amazonaws.services.timestreamwrite.model.UpdateTableRequest;
import com.amazonaws.services.timestreamwrite.model.UpdateTableResult;
import com.amazonaws.services.timestreamwrite.model.WriteRecordsRequest;
import com.amazonaws.services.timestreamwrite.model.WriteRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTimestreamWriteAsyncClient
extends AmazonTimestreamWriteClient
implements AmazonTimestreamWriteAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTimestreamWriteAsyncClientBuilder asyncBuilder() {
        return AmazonTimestreamWriteAsyncClientBuilder.standard();
    }

    AmazonTimestreamWriteAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTimestreamWriteAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDatabaseResult> createDatabaseAsync(CreateDatabaseRequest request) {
        return this.createDatabaseAsync(request, null);
    }

    @Override
    public Future<CreateDatabaseResult> createDatabaseAsync(CreateDatabaseRequest request, final AsyncHandler<CreateDatabaseRequest, CreateDatabaseResult> asyncHandler) {
        final CreateDatabaseRequest finalRequest = (CreateDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatabaseResult>(){

            @Override
            public CreateDatabaseResult call() throws Exception {
                CreateDatabaseResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeCreateDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request) {
        return this.createTableAsync(request, null);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        final CreateTableRequest finalRequest = (CreateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeCreateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatabaseResult> deleteDatabaseAsync(DeleteDatabaseRequest request) {
        return this.deleteDatabaseAsync(request, null);
    }

    @Override
    public Future<DeleteDatabaseResult> deleteDatabaseAsync(DeleteDatabaseRequest request, final AsyncHandler<DeleteDatabaseRequest, DeleteDatabaseResult> asyncHandler) {
        final DeleteDatabaseRequest finalRequest = (DeleteDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatabaseResult>(){

            @Override
            public DeleteDatabaseResult call() throws Exception {
                DeleteDatabaseResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeDeleteDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request) {
        return this.deleteTableAsync(request, null);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        final DeleteTableRequest finalRequest = (DeleteTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeDeleteTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatabaseResult> describeDatabaseAsync(DescribeDatabaseRequest request) {
        return this.describeDatabaseAsync(request, null);
    }

    @Override
    public Future<DescribeDatabaseResult> describeDatabaseAsync(DescribeDatabaseRequest request, final AsyncHandler<DescribeDatabaseRequest, DescribeDatabaseResult> asyncHandler) {
        final DescribeDatabaseRequest finalRequest = (DescribeDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatabaseResult>(){

            @Override
            public DescribeDatabaseResult call() throws Exception {
                DescribeDatabaseResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeDescribeDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request) {
        return this.describeEndpointsAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request, final AsyncHandler<DescribeEndpointsRequest, DescribeEndpointsResult> asyncHandler) {
        final DescribeEndpointsRequest finalRequest = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointsResult>(){

            @Override
            public DescribeEndpointsResult call() throws Exception {
                DescribeEndpointsResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeDescribeEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request) {
        return this.describeTableAsync(request, null);
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        final DescribeTableRequest finalRequest = (DescribeTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeDescribeTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request) {
        return this.listDatabasesAsync(request, null);
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request, final AsyncHandler<ListDatabasesRequest, ListDatabasesResult> asyncHandler) {
        final ListDatabasesRequest finalRequest = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatabasesResult>(){

            @Override
            public ListDatabasesResult call() throws Exception {
                ListDatabasesResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeListDatabases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDatabaseResult> updateDatabaseAsync(UpdateDatabaseRequest request) {
        return this.updateDatabaseAsync(request, null);
    }

    @Override
    public Future<UpdateDatabaseResult> updateDatabaseAsync(UpdateDatabaseRequest request, final AsyncHandler<UpdateDatabaseRequest, UpdateDatabaseResult> asyncHandler) {
        final UpdateDatabaseRequest finalRequest = (UpdateDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDatabaseResult>(){

            @Override
            public UpdateDatabaseResult call() throws Exception {
                UpdateDatabaseResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeUpdateDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableAsync(request, null);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        final UpdateTableRequest finalRequest = (UpdateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeUpdateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WriteRecordsResult> writeRecordsAsync(WriteRecordsRequest request) {
        return this.writeRecordsAsync(request, null);
    }

    @Override
    public Future<WriteRecordsResult> writeRecordsAsync(WriteRecordsRequest request, final AsyncHandler<WriteRecordsRequest, WriteRecordsResult> asyncHandler) {
        final WriteRecordsRequest finalRequest = (WriteRecordsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WriteRecordsResult>(){

            @Override
            public WriteRecordsResult call() throws Exception {
                WriteRecordsResult result = null;
                try {
                    result = AmazonTimestreamWriteAsyncClient.this.executeWriteRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

