/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.OperationStatus;
import com.amazonaws.services.ssmsap.model.transform.OperationMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Operation
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String type;
    private String status;
    private String statusMessage;
    private Map<String, String> properties;
    private String resourceType;
    private String resourceId;
    private String resourceArn;
    private Date startTime;
    private Date endTime;
    private Date lastUpdatedTime;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Operation withId(String id) {
        this.setId(id);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Operation withType(String type) {
        this.setType(type);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Operation withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Operation withStatus(OperationStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Operation withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Operation withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public Operation addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public Operation clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Operation withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Operation withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Operation withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Operation withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Operation withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Operation withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        return other.getLastUpdatedTime() == null || other.getLastUpdatedTime().equals(this.getLastUpdatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        return hashCode;
    }

    public Operation clone() {
        try {
            return (Operation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

