/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.Database;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DatabaseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").build();
    private static final MarshallingInfo<String> COMPONENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComponentId").build();
    private static final MarshallingInfo<List> CREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Credentials").build();
    private static final MarshallingInfo<String> DATABASEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseId").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> DATABASETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseType").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> PRIMARYHOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryHost").build();
    private static final MarshallingInfo<Integer> SQLPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SQLPort").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").timestampFormat("unixTimestamp").build();
    private static final DatabaseMarshaller instance = new DatabaseMarshaller();

    public static DatabaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(Database database, ProtocolMarshaller protocolMarshaller) {
        if (database == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)database.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)database.getComponentId(), COMPONENTID_BINDING);
            protocolMarshaller.marshall(database.getCredentials(), CREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)database.getDatabaseId(), DATABASEID_BINDING);
            protocolMarshaller.marshall((Object)database.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)database.getDatabaseType(), DATABASETYPE_BINDING);
            protocolMarshaller.marshall((Object)database.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)database.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)database.getPrimaryHost(), PRIMARYHOST_BINDING);
            protocolMarshaller.marshall((Object)database.getSQLPort(), SQLPORT_BINDING);
            protocolMarshaller.marshall((Object)database.getLastUpdated(), LASTUPDATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

