/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.Version;
import java.util.List;

@SdkInternalApi
public class VersionMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationId").build();
    private static final MarshallingInfo<String> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").build();
    private static final MarshallingInfo<List> PARAMETERDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameterDefinitions").build();
    private static final MarshallingInfo<List> REQUIREDCAPABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requiredCapabilities").build();
    private static final MarshallingInfo<Boolean> RESOURCESSUPPORTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesSupported").build();
    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").build();
    private static final MarshallingInfo<String> SOURCECODEARCHIVEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceCodeArchiveUrl").build();
    private static final MarshallingInfo<String> SOURCECODEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceCodeUrl").build();
    private static final MarshallingInfo<String> TEMPLATEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateUrl").build();
    private static final VersionMarshaller instance = new VersionMarshaller();

    public static VersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Version version, ProtocolMarshaller protocolMarshaller) {
        if (version == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)version.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)version.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(version.getParameterDefinitions(), PARAMETERDEFINITIONS_BINDING);
            protocolMarshaller.marshall(version.getRequiredCapabilities(), REQUIREDCAPABILITIES_BINDING);
            protocolMarshaller.marshall((Object)version.getResourcesSupported(), RESOURCESSUPPORTED_BINDING);
            protocolMarshaller.marshall((Object)version.getSemanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall((Object)version.getSourceCodeArchiveUrl(), SOURCECODEARCHIVEURL_BINDING);
            protocolMarshaller.marshall((Object)version.getSourceCodeUrl(), SOURCECODEURL_BINDING);
            protocolMarshaller.marshall((Object)version.getTemplateUrl(), TEMPLATEURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

