/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The properties of an AutoML candidate job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CandidateProperties" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CandidateProperties implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     */
    private CandidateArtifactLocations candidateArtifactLocations;
    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     */
    private java.util.List<MetricDatum> candidateMetrics;

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     * 
     * @param candidateArtifactLocations
     *        The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     */

    public void setCandidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
        this.candidateArtifactLocations = candidateArtifactLocations;
    }

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     * 
     * @return The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     */

    public CandidateArtifactLocations getCandidateArtifactLocations() {
        return this.candidateArtifactLocations;
    }

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     * 
     * @param candidateArtifactLocations
     *        The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CandidateProperties withCandidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
        setCandidateArtifactLocations(candidateArtifactLocations);
        return this;
    }

    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     * 
     * @return Information about the candidate metrics for an AutoML job.
     */

    public java.util.List<MetricDatum> getCandidateMetrics() {
        return candidateMetrics;
    }

    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     * 
     * @param candidateMetrics
     *        Information about the candidate metrics for an AutoML job.
     */

    public void setCandidateMetrics(java.util.Collection<MetricDatum> candidateMetrics) {
        if (candidateMetrics == null) {
            this.candidateMetrics = null;
            return;
        }

        this.candidateMetrics = new java.util.ArrayList<MetricDatum>(candidateMetrics);
    }

    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCandidateMetrics(java.util.Collection)} or {@link #withCandidateMetrics(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param candidateMetrics
     *        Information about the candidate metrics for an AutoML job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CandidateProperties withCandidateMetrics(MetricDatum... candidateMetrics) {
        if (this.candidateMetrics == null) {
            setCandidateMetrics(new java.util.ArrayList<MetricDatum>(candidateMetrics.length));
        }
        for (MetricDatum ele : candidateMetrics) {
            this.candidateMetrics.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the candidate metrics for an AutoML job.
     * </p>
     * 
     * @param candidateMetrics
     *        Information about the candidate metrics for an AutoML job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CandidateProperties withCandidateMetrics(java.util.Collection<MetricDatum> candidateMetrics) {
        setCandidateMetrics(candidateMetrics);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCandidateArtifactLocations() != null)
            sb.append("CandidateArtifactLocations: ").append(getCandidateArtifactLocations()).append(",");
        if (getCandidateMetrics() != null)
            sb.append("CandidateMetrics: ").append(getCandidateMetrics());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CandidateProperties == false)
            return false;
        CandidateProperties other = (CandidateProperties) obj;
        if (other.getCandidateArtifactLocations() == null ^ this.getCandidateArtifactLocations() == null)
            return false;
        if (other.getCandidateArtifactLocations() != null && other.getCandidateArtifactLocations().equals(this.getCandidateArtifactLocations()) == false)
            return false;
        if (other.getCandidateMetrics() == null ^ this.getCandidateMetrics() == null)
            return false;
        if (other.getCandidateMetrics() != null && other.getCandidateMetrics().equals(this.getCandidateMetrics()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCandidateArtifactLocations() == null) ? 0 : getCandidateArtifactLocations().hashCode());
        hashCode = prime * hashCode + ((getCandidateMetrics() == null) ? 0 : getCandidateMetrics().hashCode());
        return hashCode;
    }

    @Override
    public CandidateProperties clone() {
        try {
            return (CandidateProperties) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.CandidatePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
