/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DockerSettings;
import java.util.List;

@SdkInternalApi
public class DockerSettingsMarshaller {
    private static final MarshallingInfo<String> ENABLEDOCKERACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDockerAccess").build();
    private static final MarshallingInfo<List> VPCONLYTRUSTEDACCOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcOnlyTrustedAccounts").build();
    private static final DockerSettingsMarshaller instance = new DockerSettingsMarshaller();

    public static DockerSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DockerSettings dockerSettings, ProtocolMarshaller protocolMarshaller) {
        if (dockerSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dockerSettings.getEnableDockerAccess(), ENABLEDOCKERACCESS_BINDING);
            protocolMarshaller.marshall(dockerSettings.getVpcOnlyTrustedAccounts(), VPCONLYTRUSTEDACCOUNTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

