/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53.model.transform;

import static com.amazonaws.util.StringUtils.UTF8;

import java.io.StringWriter;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.*;
import com.amazonaws.transform.Marshaller;

import com.amazonaws.util.StringInputStream;

import com.amazonaws.util.XMLWriter;

/**
 * ChangeCidrCollectionRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ChangeCidrCollectionRequestMarshaller implements Marshaller<Request<ChangeCidrCollectionRequest>, ChangeCidrCollectionRequest> {

    public Request<ChangeCidrCollectionRequest> marshall(ChangeCidrCollectionRequest changeCidrCollectionRequest) {

        if (changeCidrCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ChangeCidrCollectionRequest> request = new DefaultRequest<ChangeCidrCollectionRequest>(changeCidrCollectionRequest, "AmazonRoute53");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/cidrcollection/{CidrCollectionId}";

        uriResourcePath = com.amazonaws.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "CidrCollectionId", changeCidrCollectionRequest.getId());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("ChangeCidrCollectionRequest");
            if (changeCidrCollectionRequest != null) {

                if (changeCidrCollectionRequest.getCollectionVersion() != null) {
                    xmlWriter.startElement("CollectionVersion").value(changeCidrCollectionRequest.getCollectionVersion()).endElement();
                }

                com.amazonaws.internal.SdkInternalList<CidrCollectionChange> changeCidrCollectionRequestChangesList = (com.amazonaws.internal.SdkInternalList<CidrCollectionChange>) changeCidrCollectionRequest
                        .getChanges();
                if (!changeCidrCollectionRequestChangesList.isEmpty() || !changeCidrCollectionRequestChangesList.isAutoConstruct()) {
                    xmlWriter.startElement("Changes");

                    for (CidrCollectionChange changeCidrCollectionRequestChangesListValue : changeCidrCollectionRequestChangesList) {
                        xmlWriter.startElement("member");

                        if (changeCidrCollectionRequestChangesListValue.getLocationName() != null) {
                            xmlWriter.startElement("LocationName").value(changeCidrCollectionRequestChangesListValue.getLocationName()).endElement();
                        }

                        if (changeCidrCollectionRequestChangesListValue.getAction() != null) {
                            xmlWriter.startElement("Action").value(changeCidrCollectionRequestChangesListValue.getAction()).endElement();
                        }

                        com.amazonaws.internal.SdkInternalList<String> cidrCollectionChangeCidrListList = (com.amazonaws.internal.SdkInternalList<String>) changeCidrCollectionRequestChangesListValue
                                .getCidrList();
                        if (!cidrCollectionChangeCidrListList.isEmpty() || !cidrCollectionChangeCidrListList.isAutoConstruct()) {
                            xmlWriter.startElement("CidrList");

                            for (String cidrCollectionChangeCidrListListValue : cidrCollectionChangeCidrListList) {
                                xmlWriter.startElement("Cidr");
                                xmlWriter.value(cidrCollectionChangeCidrListListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}
