/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.CellValueSynonymMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CellValueSynonym
implements Serializable,
Cloneable,
StructuredPojo {
    private String cellValue;
    private List<String> synonyms;

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public CellValueSynonym withCellValue(String cellValue) {
        this.setCellValue(cellValue);
        return this;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Collection<String> synonyms) {
        if (synonyms == null) {
            this.synonyms = null;
            return;
        }
        this.synonyms = new ArrayList<String>(synonyms);
    }

    public CellValueSynonym withSynonyms(String ... synonyms) {
        if (this.synonyms == null) {
            this.setSynonyms(new ArrayList<String>(synonyms.length));
        }
        for (String ele : synonyms) {
            this.synonyms.add(ele);
        }
        return this;
    }

    public CellValueSynonym withSynonyms(Collection<String> synonyms) {
        this.setSynonyms(synonyms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCellValue() != null) {
            sb.append("CellValue: ").append(this.getCellValue()).append(",");
        }
        if (this.getSynonyms() != null) {
            sb.append("Synonyms: ").append(this.getSynonyms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValueSynonym)) {
            return false;
        }
        CellValueSynonym other = (CellValueSynonym)obj;
        if (other.getCellValue() == null ^ this.getCellValue() == null) {
            return false;
        }
        if (other.getCellValue() != null && !other.getCellValue().equals(this.getCellValue())) {
            return false;
        }
        if (other.getSynonyms() == null ^ this.getSynonyms() == null) {
            return false;
        }
        return other.getSynonyms() == null || other.getSynonyms().equals(this.getSynonyms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCellValue() == null ? 0 : this.getCellValue().hashCode());
        hashCode = 31 * hashCode + (this.getSynonyms() == null ? 0 : this.getSynonyms().hashCode());
        return hashCode;
    }

    public CellValueSynonym clone() {
        try {
            return (CellValueSynonym)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CellValueSynonymMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

