/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mwaa.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mwaa.model.MetricDatum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PublishMetricsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String environmentName;
    private List<MetricDatum> metricData;

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public PublishMetricsRequest withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public List<MetricDatum> getMetricData() {
        return this.metricData;
    }

    public void setMetricData(Collection<MetricDatum> metricData) {
        if (metricData == null) {
            this.metricData = null;
            return;
        }
        this.metricData = new ArrayList<MetricDatum>(metricData);
    }

    public PublishMetricsRequest withMetricData(MetricDatum ... metricData) {
        if (this.metricData == null) {
            this.setMetricData(new ArrayList<MetricDatum>(metricData.length));
        }
        for (MetricDatum ele : metricData) {
            this.metricData.add(ele);
        }
        return this;
    }

    public PublishMetricsRequest withMetricData(Collection<MetricDatum> metricData) {
        this.setMetricData(metricData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getMetricData() != null) {
            sb.append("MetricData: ").append(this.getMetricData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishMetricsRequest)) {
            return false;
        }
        PublishMetricsRequest other = (PublishMetricsRequest)obj;
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getMetricData() == null ^ this.getMetricData() == null) {
            return false;
        }
        return other.getMetricData() == null || other.getMetricData().equals(this.getMetricData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricData() == null ? 0 : this.getMetricData().hashCode());
        return hashCode;
    }

    public PublishMetricsRequest clone() {
        return (PublishMetricsRequest)super.clone();
    }
}

