/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lookoutequipment;

import javax.annotation.Generated;

import com.amazonaws.services.lookoutequipment.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonLookoutEquipment}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLookoutEquipment implements AmazonLookoutEquipment {

    protected AbstractAmazonLookoutEquipment() {
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInferenceSchedulerResult createInferenceScheduler(CreateInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLabelResult createLabel(CreateLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLabelGroupResult createLabelGroup(CreateLabelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRetrainingSchedulerResult createRetrainingScheduler(CreateRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInferenceSchedulerResult deleteInferenceScheduler(DeleteInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLabelResult deleteLabel(DeleteLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLabelGroupResult deleteLabelGroup(DeleteLabelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRetrainingSchedulerResult deleteRetrainingScheduler(DeleteRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataIngestionJobResult describeDataIngestionJob(DescribeDataIngestionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInferenceSchedulerResult describeInferenceScheduler(DescribeInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLabelResult describeLabel(DescribeLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLabelGroupResult describeLabelGroup(DescribeLabelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelVersionResult describeModelVersion(DescribeModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourcePolicyResult describeResourcePolicy(DescribeResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRetrainingSchedulerResult describeRetrainingScheduler(DescribeRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportDatasetResult importDataset(ImportDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportModelVersionResult importModelVersion(ImportModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataIngestionJobsResult listDataIngestionJobs(ListDataIngestionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceEventsResult listInferenceEvents(ListInferenceEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceExecutionsResult listInferenceExecutions(ListInferenceExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInferenceSchedulersResult listInferenceSchedulers(ListInferenceSchedulersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelGroupsResult listLabelGroups(ListLabelGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelsResult listLabels(ListLabelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelVersionsResult listModelVersions(ListModelVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRetrainingSchedulersResult listRetrainingSchedulers(ListRetrainingSchedulersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSensorStatisticsResult listSensorStatistics(ListSensorStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDataIngestionJobResult startDataIngestionJob(StartDataIngestionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartInferenceSchedulerResult startInferenceScheduler(StartInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartRetrainingSchedulerResult startRetrainingScheduler(StartRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopInferenceSchedulerResult stopInferenceScheduler(StopInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopRetrainingSchedulerResult stopRetrainingScheduler(StopRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateActiveModelVersionResult updateActiveModelVersion(UpdateActiveModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInferenceSchedulerResult updateInferenceScheduler(UpdateInferenceSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLabelGroupResult updateLabelGroup(UpdateLabelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelResult updateModel(UpdateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRetrainingSchedulerResult updateRetrainingScheduler(UpdateRetrainingSchedulerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
