/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ivs.model.AudioConfiguration;

@SdkInternalApi
public class AudioConfigurationMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codec").build();
    private static final MarshallingInfo<Long> TARGETBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetBitrate").build();
    private static final MarshallingInfo<Long> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final MarshallingInfo<Long> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final AudioConfigurationMarshaller instance = new AudioConfigurationMarshaller();

    public static AudioConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudioConfiguration audioConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (audioConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioConfiguration.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)audioConfiguration.getTargetBitrate(), TARGETBITRATE_BINDING);
            protocolMarshaller.marshall((Object)audioConfiguration.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)audioConfiguration.getChannels(), CHANNELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

