/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotfleetwise;

import javax.annotation.Generated;

import com.amazonaws.services.iotfleetwise.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTFleetWise}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTFleetWise implements AWSIoTFleetWise {

    protected AbstractAWSIoTFleetWise() {
    }

    @Override
    public AssociateVehicleFleetResult associateVehicleFleet(AssociateVehicleFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateVehicleResult batchCreateVehicle(BatchCreateVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateVehicleResult batchUpdateVehicle(BatchUpdateVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCampaignResult createCampaign(CreateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDecoderManifestResult createDecoderManifest(CreateDecoderManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetResult createFleet(CreateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelManifestResult createModelManifest(CreateModelManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSignalCatalogResult createSignalCatalog(CreateSignalCatalogRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVehicleResult createVehicle(CreateVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCampaignResult deleteCampaign(DeleteCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDecoderManifestResult deleteDecoderManifest(DeleteDecoderManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetResult deleteFleet(DeleteFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelManifestResult deleteModelManifest(DeleteModelManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSignalCatalogResult deleteSignalCatalog(DeleteSignalCatalogRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVehicleResult deleteVehicle(DeleteVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateVehicleFleetResult disassociateVehicleFleet(DisassociateVehicleFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignResult getCampaign(GetCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDecoderManifestResult getDecoderManifest(GetDecoderManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEncryptionConfigurationResult getEncryptionConfiguration(GetEncryptionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFleetResult getFleet(GetFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLoggingOptionsResult getLoggingOptions(GetLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelManifestResult getModelManifest(GetModelManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRegisterAccountStatusResult getRegisterAccountStatus(GetRegisterAccountStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSignalCatalogResult getSignalCatalog(GetSignalCatalogRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVehicleResult getVehicle(GetVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVehicleStatusResult getVehicleStatus(GetVehicleStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportDecoderManifestResult importDecoderManifest(ImportDecoderManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportSignalCatalogResult importSignalCatalog(ImportSignalCatalogRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCampaignsResult listCampaigns(ListCampaignsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDecoderManifestNetworkInterfacesResult listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDecoderManifestSignalsResult listDecoderManifestSignals(ListDecoderManifestSignalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDecoderManifestsResult listDecoderManifests(ListDecoderManifestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetsResult listFleets(ListFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetsForVehicleResult listFleetsForVehicle(ListFleetsForVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelManifestNodesResult listModelManifestNodes(ListModelManifestNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelManifestsResult listModelManifests(ListModelManifestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSignalCatalogNodesResult listSignalCatalogNodes(ListSignalCatalogNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSignalCatalogsResult listSignalCatalogs(ListSignalCatalogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVehiclesResult listVehicles(ListVehiclesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVehiclesInFleetResult listVehiclesInFleet(ListVehiclesInFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEncryptionConfigurationResult putEncryptionConfiguration(PutEncryptionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterAccountResult registerAccount(RegisterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignResult updateCampaign(UpdateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDecoderManifestResult updateDecoderManifest(UpdateDecoderManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFleetResult updateFleet(UpdateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelManifestResult updateModelManifest(UpdateModelManifestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSignalCatalogResult updateSignalCatalog(UpdateSignalCatalogRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVehicleResult updateVehicle(UpdateVehicleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
