/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.UserProperty;
import com.amazonaws.services.iot.model.transform.MqttHeadersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MqttHeaders
implements Serializable,
Cloneable,
StructuredPojo {
    private String payloadFormatIndicator;
    private String contentType;
    private String responseTopic;
    private String correlationData;
    private String messageExpiry;
    private List<UserProperty> userProperties;

    public void setPayloadFormatIndicator(String payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
    }

    public String getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public MqttHeaders withPayloadFormatIndicator(String payloadFormatIndicator) {
        this.setPayloadFormatIndicator(payloadFormatIndicator);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public MqttHeaders withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setResponseTopic(String responseTopic) {
        this.responseTopic = responseTopic;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public MqttHeaders withResponseTopic(String responseTopic) {
        this.setResponseTopic(responseTopic);
        return this;
    }

    public void setCorrelationData(String correlationData) {
        this.correlationData = correlationData;
    }

    public String getCorrelationData() {
        return this.correlationData;
    }

    public MqttHeaders withCorrelationData(String correlationData) {
        this.setCorrelationData(correlationData);
        return this;
    }

    public void setMessageExpiry(String messageExpiry) {
        this.messageExpiry = messageExpiry;
    }

    public String getMessageExpiry() {
        return this.messageExpiry;
    }

    public MqttHeaders withMessageExpiry(String messageExpiry) {
        this.setMessageExpiry(messageExpiry);
        return this;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Collection<UserProperty> userProperties) {
        if (userProperties == null) {
            this.userProperties = null;
            return;
        }
        this.userProperties = new ArrayList<UserProperty>(userProperties);
    }

    public MqttHeaders withUserProperties(UserProperty ... userProperties) {
        if (this.userProperties == null) {
            this.setUserProperties(new ArrayList<UserProperty>(userProperties.length));
        }
        for (UserProperty ele : userProperties) {
            this.userProperties.add(ele);
        }
        return this;
    }

    public MqttHeaders withUserProperties(Collection<UserProperty> userProperties) {
        this.setUserProperties(userProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPayloadFormatIndicator() != null) {
            sb.append("PayloadFormatIndicator: ").append(this.getPayloadFormatIndicator()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getResponseTopic() != null) {
            sb.append("ResponseTopic: ").append(this.getResponseTopic()).append(",");
        }
        if (this.getCorrelationData() != null) {
            sb.append("CorrelationData: ").append(this.getCorrelationData()).append(",");
        }
        if (this.getMessageExpiry() != null) {
            sb.append("MessageExpiry: ").append(this.getMessageExpiry()).append(",");
        }
        if (this.getUserProperties() != null) {
            sb.append("UserProperties: ").append(this.getUserProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MqttHeaders)) {
            return false;
        }
        MqttHeaders other = (MqttHeaders)obj;
        if (other.getPayloadFormatIndicator() == null ^ this.getPayloadFormatIndicator() == null) {
            return false;
        }
        if (other.getPayloadFormatIndicator() != null && !other.getPayloadFormatIndicator().equals(this.getPayloadFormatIndicator())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getResponseTopic() == null ^ this.getResponseTopic() == null) {
            return false;
        }
        if (other.getResponseTopic() != null && !other.getResponseTopic().equals(this.getResponseTopic())) {
            return false;
        }
        if (other.getCorrelationData() == null ^ this.getCorrelationData() == null) {
            return false;
        }
        if (other.getCorrelationData() != null && !other.getCorrelationData().equals(this.getCorrelationData())) {
            return false;
        }
        if (other.getMessageExpiry() == null ^ this.getMessageExpiry() == null) {
            return false;
        }
        if (other.getMessageExpiry() != null && !other.getMessageExpiry().equals(this.getMessageExpiry())) {
            return false;
        }
        if (other.getUserProperties() == null ^ this.getUserProperties() == null) {
            return false;
        }
        return other.getUserProperties() == null || other.getUserProperties().equals(this.getUserProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPayloadFormatIndicator() == null ? 0 : this.getPayloadFormatIndicator().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getResponseTopic() == null ? 0 : this.getResponseTopic().hashCode());
        hashCode = 31 * hashCode + (this.getCorrelationData() == null ? 0 : this.getCorrelationData().hashCode());
        hashCode = 31 * hashCode + (this.getMessageExpiry() == null ? 0 : this.getMessageExpiry().hashCode());
        hashCode = 31 * hashCode + (this.getUserProperties() == null ? 0 : this.getUserProperties().hashCode());
        return hashCode;
    }

    public MqttHeaders clone() {
        try {
            return (MqttHeaders)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MqttHeadersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

