/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.entityresolution.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.entityresolution.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * IdMappingJobMetricsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class IdMappingJobMetricsMarshaller {

    private static final MarshallingInfo<Integer> INPUTRECORDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputRecords").build();
    private static final MarshallingInfo<Integer> RECORDSNOTPROCESSED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordsNotProcessed").build();
    private static final MarshallingInfo<Integer> TOTALMAPPEDRECORDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalMappedRecords").build();
    private static final MarshallingInfo<Integer> TOTALMAPPEDSOURCERECORDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalMappedSourceRecords").build();
    private static final MarshallingInfo<Integer> TOTALMAPPEDTARGETRECORDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalMappedTargetRecords").build();
    private static final MarshallingInfo<Integer> TOTALRECORDSPROCESSED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalRecordsProcessed").build();

    private static final IdMappingJobMetricsMarshaller instance = new IdMappingJobMetricsMarshaller();

    public static IdMappingJobMetricsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(IdMappingJobMetrics idMappingJobMetrics, ProtocolMarshaller protocolMarshaller) {

        if (idMappingJobMetrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(idMappingJobMetrics.getInputRecords(), INPUTRECORDS_BINDING);
            protocolMarshaller.marshall(idMappingJobMetrics.getRecordsNotProcessed(), RECORDSNOTPROCESSED_BINDING);
            protocolMarshaller.marshall(idMappingJobMetrics.getTotalMappedRecords(), TOTALMAPPEDRECORDS_BINDING);
            protocolMarshaller.marshall(idMappingJobMetrics.getTotalMappedSourceRecords(), TOTALMAPPEDSOURCERECORDS_BINDING);
            protocolMarshaller.marshall(idMappingJobMetrics.getTotalMappedTargetRecords(), TOTALMAPPEDTARGETRECORDS_BINDING);
            protocolMarshaller.marshall(idMappingJobMetrics.getTotalRecordsProcessed(), TOTALRECORDSPROCESSED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
