/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.emrserverless.AWSEMRServerlessAsync;
import com.amazonaws.services.emrserverless.AWSEMRServerlessAsyncClientBuilder;
import com.amazonaws.services.emrserverless.AWSEMRServerlessClient;
import com.amazonaws.services.emrserverless.model.CancelJobRunRequest;
import com.amazonaws.services.emrserverless.model.CancelJobRunResult;
import com.amazonaws.services.emrserverless.model.CreateApplicationRequest;
import com.amazonaws.services.emrserverless.model.CreateApplicationResult;
import com.amazonaws.services.emrserverless.model.DeleteApplicationRequest;
import com.amazonaws.services.emrserverless.model.DeleteApplicationResult;
import com.amazonaws.services.emrserverless.model.GetApplicationRequest;
import com.amazonaws.services.emrserverless.model.GetApplicationResult;
import com.amazonaws.services.emrserverless.model.GetDashboardForJobRunRequest;
import com.amazonaws.services.emrserverless.model.GetDashboardForJobRunResult;
import com.amazonaws.services.emrserverless.model.GetJobRunRequest;
import com.amazonaws.services.emrserverless.model.GetJobRunResult;
import com.amazonaws.services.emrserverless.model.ListApplicationsRequest;
import com.amazonaws.services.emrserverless.model.ListApplicationsResult;
import com.amazonaws.services.emrserverless.model.ListJobRunAttemptsRequest;
import com.amazonaws.services.emrserverless.model.ListJobRunAttemptsResult;
import com.amazonaws.services.emrserverless.model.ListJobRunsRequest;
import com.amazonaws.services.emrserverless.model.ListJobRunsResult;
import com.amazonaws.services.emrserverless.model.ListTagsForResourceRequest;
import com.amazonaws.services.emrserverless.model.ListTagsForResourceResult;
import com.amazonaws.services.emrserverless.model.StartApplicationRequest;
import com.amazonaws.services.emrserverless.model.StartApplicationResult;
import com.amazonaws.services.emrserverless.model.StartJobRunRequest;
import com.amazonaws.services.emrserverless.model.StartJobRunResult;
import com.amazonaws.services.emrserverless.model.StopApplicationRequest;
import com.amazonaws.services.emrserverless.model.StopApplicationResult;
import com.amazonaws.services.emrserverless.model.TagResourceRequest;
import com.amazonaws.services.emrserverless.model.TagResourceResult;
import com.amazonaws.services.emrserverless.model.UntagResourceRequest;
import com.amazonaws.services.emrserverless.model.UntagResourceResult;
import com.amazonaws.services.emrserverless.model.UpdateApplicationRequest;
import com.amazonaws.services.emrserverless.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSEMRServerlessAsyncClient
extends AWSEMRServerlessClient
implements AWSEMRServerlessAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSEMRServerlessAsyncClientBuilder asyncBuilder() {
        return AWSEMRServerlessAsyncClientBuilder.standard();
    }

    AWSEMRServerlessAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSEMRServerlessAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobRunResult> cancelJobRunAsync(CancelJobRunRequest request) {
        return this.cancelJobRunAsync(request, null);
    }

    @Override
    public Future<CancelJobRunResult> cancelJobRunAsync(CancelJobRunRequest request, final AsyncHandler<CancelJobRunRequest, CancelJobRunResult> asyncHandler) {
        final CancelJobRunRequest finalRequest = (CancelJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobRunResult>(){

            @Override
            public CancelJobRunResult call() throws Exception {
                CancelJobRunResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeCancelJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        final DeleteApplicationRequest finalRequest = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeDeleteApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {
        return this.getApplicationAsync(request, null);
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request, final AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {
        final GetApplicationRequest finalRequest = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetApplicationResult>(){

            @Override
            public GetApplicationResult call() throws Exception {
                GetApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeGetApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDashboardForJobRunResult> getDashboardForJobRunAsync(GetDashboardForJobRunRequest request) {
        return this.getDashboardForJobRunAsync(request, null);
    }

    @Override
    public Future<GetDashboardForJobRunResult> getDashboardForJobRunAsync(GetDashboardForJobRunRequest request, final AsyncHandler<GetDashboardForJobRunRequest, GetDashboardForJobRunResult> asyncHandler) {
        final GetDashboardForJobRunRequest finalRequest = (GetDashboardForJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDashboardForJobRunResult>(){

            @Override
            public GetDashboardForJobRunResult call() throws Exception {
                GetDashboardForJobRunResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeGetDashboardForJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobRunResult> getJobRunAsync(GetJobRunRequest request) {
        return this.getJobRunAsync(request, null);
    }

    @Override
    public Future<GetJobRunResult> getJobRunAsync(GetJobRunRequest request, final AsyncHandler<GetJobRunRequest, GetJobRunResult> asyncHandler) {
        final GetJobRunRequest finalRequest = (GetJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobRunResult>(){

            @Override
            public GetJobRunResult call() throws Exception {
                GetJobRunResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeGetJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobRunAttemptsResult> listJobRunAttemptsAsync(ListJobRunAttemptsRequest request) {
        return this.listJobRunAttemptsAsync(request, null);
    }

    @Override
    public Future<ListJobRunAttemptsResult> listJobRunAttemptsAsync(ListJobRunAttemptsRequest request, final AsyncHandler<ListJobRunAttemptsRequest, ListJobRunAttemptsResult> asyncHandler) {
        final ListJobRunAttemptsRequest finalRequest = (ListJobRunAttemptsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobRunAttemptsResult>(){

            @Override
            public ListJobRunAttemptsResult call() throws Exception {
                ListJobRunAttemptsResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeListJobRunAttempts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobRunsResult> listJobRunsAsync(ListJobRunsRequest request) {
        return this.listJobRunsAsync(request, null);
    }

    @Override
    public Future<ListJobRunsResult> listJobRunsAsync(ListJobRunsRequest request, final AsyncHandler<ListJobRunsRequest, ListJobRunsResult> asyncHandler) {
        final ListJobRunsRequest finalRequest = (ListJobRunsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobRunsResult>(){

            @Override
            public ListJobRunsResult call() throws Exception {
                ListJobRunsResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeListJobRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartApplicationResult> startApplicationAsync(StartApplicationRequest request) {
        return this.startApplicationAsync(request, null);
    }

    @Override
    public Future<StartApplicationResult> startApplicationAsync(StartApplicationRequest request, final AsyncHandler<StartApplicationRequest, StartApplicationResult> asyncHandler) {
        final StartApplicationRequest finalRequest = (StartApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartApplicationResult>(){

            @Override
            public StartApplicationResult call() throws Exception {
                StartApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeStartApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartJobRunResult> startJobRunAsync(StartJobRunRequest request) {
        return this.startJobRunAsync(request, null);
    }

    @Override
    public Future<StartJobRunResult> startJobRunAsync(StartJobRunRequest request, final AsyncHandler<StartJobRunRequest, StartJobRunResult> asyncHandler) {
        final StartJobRunRequest finalRequest = (StartJobRunRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartJobRunResult>(){

            @Override
            public StartJobRunResult call() throws Exception {
                StartJobRunResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeStartJobRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopApplicationResult> stopApplicationAsync(StopApplicationRequest request) {
        return this.stopApplicationAsync(request, null);
    }

    @Override
    public Future<StopApplicationResult> stopApplicationAsync(StopApplicationRequest request, final AsyncHandler<StopApplicationRequest, StopApplicationResult> asyncHandler) {
        final StopApplicationRequest finalRequest = (StopApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopApplicationResult>(){

            @Override
            public StopApplicationResult call() throws Exception {
                StopApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeStopApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        final UpdateApplicationRequest finalRequest = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result = null;
                try {
                    result = AWSEMRServerlessAsyncClient.this.executeUpdateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

