/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SearchFilter
implements Serializable,
Cloneable {
    private String attribute;
    private String operator;
    private SdkInternalList<String> values;

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public SearchFilter withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public SearchFilter withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new SdkInternalList();
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new SdkInternalList(values);
    }

    public SearchFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues((Collection<String>)new SdkInternalList(values.length));
        }
        for (String ele : values) {
            this.values.add((Object)ele);
        }
        return this;
    }

    public SearchFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFilter)) {
            return false;
        }
        SearchFilter other = (SearchFilter)obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        if (other.getOperator() != null && !other.getOperator().equals(this.getOperator())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public SearchFilter clone() {
        try {
            return (SearchFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

