/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.ApplicationMetrics;
import com.amazonaws.services.elasticbeanstalk.model.transform.LatencyStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.StatusCodesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ApplicationMetricsStaxUnmarshaller
implements Unmarshaller<ApplicationMetrics, StaxUnmarshallerContext> {
    private static ApplicationMetricsStaxUnmarshaller instance;

    public ApplicationMetrics unmarshall(StaxUnmarshallerContext context) throws Exception {
        ApplicationMetrics applicationMetrics = new ApplicationMetrics();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return applicationMetrics;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Duration", targetDepth)) {
                    applicationMetrics.setDuration(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestCount", targetDepth)) {
                    applicationMetrics.setRequestCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusCodes", targetDepth)) {
                    applicationMetrics.setStatusCodes(StatusCodesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Latency", targetDepth)) continue;
                applicationMetrics.setLatency(LatencyStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return applicationMetrics;
    }

    public static ApplicationMetricsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationMetricsStaxUnmarshaller();
        }
        return instance;
    }
}

