/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteTimeSeriesDataPointsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series form.
     * </p>
     */
    private String domainIdentifier;
    /**
     * <p>
     * The ID of the asset for which you want to delete a time series form.
     * </p>
     */
    private String entityIdentifier;
    /**
     * <p>
     * The type of the asset for which you want to delete a time series form.
     * </p>
     */
    private String entityType;
    /**
     * <p>
     * The name of the time series form that you want to delete.
     * </p>
     */
    private String formName;

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *        populated if not provided.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *         populated if not provided.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *        populated if not provided.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTimeSeriesDataPointsRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series
     *        form.
     */

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series form.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series
     *         form.
     */

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series
     *        form.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTimeSeriesDataPointsRequest withDomainIdentifier(String domainIdentifier) {
        setDomainIdentifier(domainIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param entityIdentifier
     *        The ID of the asset for which you want to delete a time series form.
     */

    public void setEntityIdentifier(String entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @return The ID of the asset for which you want to delete a time series form.
     */

    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param entityIdentifier
     *        The ID of the asset for which you want to delete a time series form.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTimeSeriesDataPointsRequest withEntityIdentifier(String entityIdentifier) {
        setEntityIdentifier(entityIdentifier);
        return this;
    }

    /**
     * <p>
     * The type of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to delete a time series form.
     * @see TimeSeriesEntityType
     */

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    /**
     * <p>
     * The type of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @return The type of the asset for which you want to delete a time series form.
     * @see TimeSeriesEntityType
     */

    public String getEntityType() {
        return this.entityType;
    }

    /**
     * <p>
     * The type of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to delete a time series form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeSeriesEntityType
     */

    public DeleteTimeSeriesDataPointsRequest withEntityType(String entityType) {
        setEntityType(entityType);
        return this;
    }

    /**
     * <p>
     * The type of the asset for which you want to delete a time series form.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to delete a time series form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeSeriesEntityType
     */

    public DeleteTimeSeriesDataPointsRequest withEntityType(TimeSeriesEntityType entityType) {
        this.entityType = entityType.toString();
        return this;
    }

    /**
     * <p>
     * The name of the time series form that you want to delete.
     * </p>
     * 
     * @param formName
     *        The name of the time series form that you want to delete.
     */

    public void setFormName(String formName) {
        this.formName = formName;
    }

    /**
     * <p>
     * The name of the time series form that you want to delete.
     * </p>
     * 
     * @return The name of the time series form that you want to delete.
     */

    public String getFormName() {
        return this.formName;
    }

    /**
     * <p>
     * The name of the time series form that you want to delete.
     * </p>
     * 
     * @param formName
     *        The name of the time series form that you want to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTimeSeriesDataPointsRequest withFormName(String formName) {
        setFormName(formName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getDomainIdentifier() != null)
            sb.append("DomainIdentifier: ").append(getDomainIdentifier()).append(",");
        if (getEntityIdentifier() != null)
            sb.append("EntityIdentifier: ").append(getEntityIdentifier()).append(",");
        if (getEntityType() != null)
            sb.append("EntityType: ").append(getEntityType()).append(",");
        if (getFormName() != null)
            sb.append("FormName: ").append(getFormName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteTimeSeriesDataPointsRequest == false)
            return false;
        DeleteTimeSeriesDataPointsRequest other = (DeleteTimeSeriesDataPointsRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null)
            return false;
        if (other.getDomainIdentifier() != null && other.getDomainIdentifier().equals(this.getDomainIdentifier()) == false)
            return false;
        if (other.getEntityIdentifier() == null ^ this.getEntityIdentifier() == null)
            return false;
        if (other.getEntityIdentifier() != null && other.getEntityIdentifier().equals(this.getEntityIdentifier()) == false)
            return false;
        if (other.getEntityType() == null ^ this.getEntityType() == null)
            return false;
        if (other.getEntityType() != null && other.getEntityType().equals(this.getEntityType()) == false)
            return false;
        if (other.getFormName() == null ^ this.getFormName() == null)
            return false;
        if (other.getFormName() != null && other.getFormName().equals(this.getFormName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getDomainIdentifier() == null) ? 0 : getDomainIdentifier().hashCode());
        hashCode = prime * hashCode + ((getEntityIdentifier() == null) ? 0 : getEntityIdentifier().hashCode());
        hashCode = prime * hashCode + ((getEntityType() == null) ? 0 : getEntityType().hashCode());
        hashCode = prime * hashCode + ((getFormName() == null) ? 0 : getFormName().hashCode());
        return hashCode;
    }

    @Override
    public DeleteTimeSeriesDataPointsRequest clone() {
        return (DeleteTimeSeriesDataPointsRequest) super.clone();
    }

}
