/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.MetricFilterV2;
import com.amazonaws.services.connect.model.ThresholdV2;
import com.amazonaws.services.connect.model.transform.MetricV2Marshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricV2
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<ThresholdV2> threshold;
    private List<MetricFilterV2> metricFilters;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MetricV2 withName(String name) {
        this.setName(name);
        return this;
    }

    public List<ThresholdV2> getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Collection<ThresholdV2> threshold) {
        if (threshold == null) {
            this.threshold = null;
            return;
        }
        this.threshold = new ArrayList<ThresholdV2>(threshold);
    }

    public MetricV2 withThreshold(ThresholdV2 ... threshold) {
        if (this.threshold == null) {
            this.setThreshold(new ArrayList<ThresholdV2>(threshold.length));
        }
        for (ThresholdV2 ele : threshold) {
            this.threshold.add(ele);
        }
        return this;
    }

    public MetricV2 withThreshold(Collection<ThresholdV2> threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public List<MetricFilterV2> getMetricFilters() {
        return this.metricFilters;
    }

    public void setMetricFilters(Collection<MetricFilterV2> metricFilters) {
        if (metricFilters == null) {
            this.metricFilters = null;
            return;
        }
        this.metricFilters = new ArrayList<MetricFilterV2>(metricFilters);
    }

    public MetricV2 withMetricFilters(MetricFilterV2 ... metricFilters) {
        if (this.metricFilters == null) {
            this.setMetricFilters(new ArrayList<MetricFilterV2>(metricFilters.length));
        }
        for (MetricFilterV2 ele : metricFilters) {
            this.metricFilters.add(ele);
        }
        return this;
    }

    public MetricV2 withMetricFilters(Collection<MetricFilterV2> metricFilters) {
        this.setMetricFilters(metricFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold()).append(",");
        }
        if (this.getMetricFilters() != null) {
            sb.append("MetricFilters: ").append(this.getMetricFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricV2)) {
            return false;
        }
        MetricV2 other = (MetricV2)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getMetricFilters() == null ^ this.getMetricFilters() == null) {
            return false;
        }
        return other.getMetricFilters() == null || other.getMetricFilters().equals(this.getMetricFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getMetricFilters() == null ? 0 : this.getMetricFilters().hashCode());
        return hashCode;
    }

    public MetricV2 clone() {
        try {
            return (MetricV2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricV2Marshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

