/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListDefaultVocabulariesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of default vocabularies.
     * </p>
     */
    private java.util.List<DefaultVocabulary> defaultVocabularyList;
    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of default vocabularies.
     * </p>
     * 
     * @return A list of default vocabularies.
     */

    public java.util.List<DefaultVocabulary> getDefaultVocabularyList() {
        return defaultVocabularyList;
    }

    /**
     * <p>
     * A list of default vocabularies.
     * </p>
     * 
     * @param defaultVocabularyList
     *        A list of default vocabularies.
     */

    public void setDefaultVocabularyList(java.util.Collection<DefaultVocabulary> defaultVocabularyList) {
        if (defaultVocabularyList == null) {
            this.defaultVocabularyList = null;
            return;
        }

        this.defaultVocabularyList = new java.util.ArrayList<DefaultVocabulary>(defaultVocabularyList);
    }

    /**
     * <p>
     * A list of default vocabularies.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDefaultVocabularyList(java.util.Collection)} or
     * {@link #withDefaultVocabularyList(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param defaultVocabularyList
     *        A list of default vocabularies.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDefaultVocabulariesResult withDefaultVocabularyList(DefaultVocabulary... defaultVocabularyList) {
        if (this.defaultVocabularyList == null) {
            setDefaultVocabularyList(new java.util.ArrayList<DefaultVocabulary>(defaultVocabularyList.length));
        }
        for (DefaultVocabulary ele : defaultVocabularyList) {
            this.defaultVocabularyList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of default vocabularies.
     * </p>
     * 
     * @param defaultVocabularyList
     *        A list of default vocabularies.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDefaultVocabulariesResult withDefaultVocabularyList(java.util.Collection<DefaultVocabulary> defaultVocabularyList) {
        setDefaultVocabularyList(defaultVocabularyList);
        return this;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDefaultVocabulariesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDefaultVocabularyList() != null)
            sb.append("DefaultVocabularyList: ").append(getDefaultVocabularyList()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListDefaultVocabulariesResult == false)
            return false;
        ListDefaultVocabulariesResult other = (ListDefaultVocabulariesResult) obj;
        if (other.getDefaultVocabularyList() == null ^ this.getDefaultVocabularyList() == null)
            return false;
        if (other.getDefaultVocabularyList() != null && other.getDefaultVocabularyList().equals(this.getDefaultVocabularyList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDefaultVocabularyList() == null) ? 0 : getDefaultVocabularyList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListDefaultVocabulariesResult clone() {
        try {
            return (ListDefaultVocabulariesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
