/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.ECSServiceMetricName;
import com.amazonaws.services.computeoptimizer.model.transform.ECSServiceProjectedMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ECSServiceProjectedMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<Date> timestamps;
    private List<Double> upperBoundValues;
    private List<Double> lowerBoundValues;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ECSServiceProjectedMetric withName(String name) {
        this.setName(name);
        return this;
    }

    public ECSServiceProjectedMetric withName(ECSServiceMetricName name) {
        this.name = name.toString();
        return this;
    }

    public List<Date> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(Collection<Date> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }
        this.timestamps = new ArrayList<Date>(timestamps);
    }

    public ECSServiceProjectedMetric withTimestamps(Date ... timestamps) {
        if (this.timestamps == null) {
            this.setTimestamps(new ArrayList<Date>(timestamps.length));
        }
        for (Date ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    public ECSServiceProjectedMetric withTimestamps(Collection<Date> timestamps) {
        this.setTimestamps(timestamps);
        return this;
    }

    public List<Double> getUpperBoundValues() {
        return this.upperBoundValues;
    }

    public void setUpperBoundValues(Collection<Double> upperBoundValues) {
        if (upperBoundValues == null) {
            this.upperBoundValues = null;
            return;
        }
        this.upperBoundValues = new ArrayList<Double>(upperBoundValues);
    }

    public ECSServiceProjectedMetric withUpperBoundValues(Double ... upperBoundValues) {
        if (this.upperBoundValues == null) {
            this.setUpperBoundValues(new ArrayList<Double>(upperBoundValues.length));
        }
        for (Double ele : upperBoundValues) {
            this.upperBoundValues.add(ele);
        }
        return this;
    }

    public ECSServiceProjectedMetric withUpperBoundValues(Collection<Double> upperBoundValues) {
        this.setUpperBoundValues(upperBoundValues);
        return this;
    }

    public List<Double> getLowerBoundValues() {
        return this.lowerBoundValues;
    }

    public void setLowerBoundValues(Collection<Double> lowerBoundValues) {
        if (lowerBoundValues == null) {
            this.lowerBoundValues = null;
            return;
        }
        this.lowerBoundValues = new ArrayList<Double>(lowerBoundValues);
    }

    public ECSServiceProjectedMetric withLowerBoundValues(Double ... lowerBoundValues) {
        if (this.lowerBoundValues == null) {
            this.setLowerBoundValues(new ArrayList<Double>(lowerBoundValues.length));
        }
        for (Double ele : lowerBoundValues) {
            this.lowerBoundValues.add(ele);
        }
        return this;
    }

    public ECSServiceProjectedMetric withLowerBoundValues(Collection<Double> lowerBoundValues) {
        this.setLowerBoundValues(lowerBoundValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTimestamps() != null) {
            sb.append("Timestamps: ").append(this.getTimestamps()).append(",");
        }
        if (this.getUpperBoundValues() != null) {
            sb.append("UpperBoundValues: ").append(this.getUpperBoundValues()).append(",");
        }
        if (this.getLowerBoundValues() != null) {
            sb.append("LowerBoundValues: ").append(this.getLowerBoundValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceProjectedMetric)) {
            return false;
        }
        ECSServiceProjectedMetric other = (ECSServiceProjectedMetric)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTimestamps() == null ^ this.getTimestamps() == null) {
            return false;
        }
        if (other.getTimestamps() != null && !other.getTimestamps().equals(this.getTimestamps())) {
            return false;
        }
        if (other.getUpperBoundValues() == null ^ this.getUpperBoundValues() == null) {
            return false;
        }
        if (other.getUpperBoundValues() != null && !other.getUpperBoundValues().equals(this.getUpperBoundValues())) {
            return false;
        }
        if (other.getLowerBoundValues() == null ^ this.getLowerBoundValues() == null) {
            return false;
        }
        return other.getLowerBoundValues() == null || other.getLowerBoundValues().equals(this.getLowerBoundValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamps() == null ? 0 : this.getTimestamps().hashCode());
        hashCode = 31 * hashCode + (this.getUpperBoundValues() == null ? 0 : this.getUpperBoundValues().hashCode());
        hashCode = 31 * hashCode + (this.getLowerBoundValues() == null ? 0 : this.getLowerBoundValues().hashCode());
        return hashCode;
    }

    public ECSServiceProjectedMetric clone() {
        try {
            return (ECSServiceProjectedMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ECSServiceProjectedMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

