/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeartifact.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDomainRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domain;
    private String encryptionKey;
    private List<Tag> tags;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public CreateDomainRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public CreateDomainRequest withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDomainRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDomainRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDomainRequest clone() {
        return (CreateDomainRequest)super.clone();
    }
}

