/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CopyPackageVersionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domain;
    private String domainOwner;
    private String sourceRepository;
    private String destinationRepository;
    private String format;
    private String namespace;
    private String packageValue;
    private List<String> versions;
    private Map<String, String> versionRevisions;
    private Boolean allowOverwrite;
    private Boolean includeFromUpstream;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public CopyPackageVersionsRequest withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setDomainOwner(String domainOwner) {
        this.domainOwner = domainOwner;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public CopyPackageVersionsRequest withDomainOwner(String domainOwner) {
        this.setDomainOwner(domainOwner);
        return this;
    }

    public void setSourceRepository(String sourceRepository) {
        this.sourceRepository = sourceRepository;
    }

    public String getSourceRepository() {
        return this.sourceRepository;
    }

    public CopyPackageVersionsRequest withSourceRepository(String sourceRepository) {
        this.setSourceRepository(sourceRepository);
        return this;
    }

    public void setDestinationRepository(String destinationRepository) {
        this.destinationRepository = destinationRepository;
    }

    public String getDestinationRepository() {
        return this.destinationRepository;
    }

    public CopyPackageVersionsRequest withDestinationRepository(String destinationRepository) {
        this.setDestinationRepository(destinationRepository);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public CopyPackageVersionsRequest withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public CopyPackageVersionsRequest withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CopyPackageVersionsRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackage(String packageValue) {
        this.packageValue = packageValue;
    }

    public String getPackage() {
        return this.packageValue;
    }

    public CopyPackageVersionsRequest withPackage(String packageValue) {
        this.setPackage(packageValue);
        return this;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<String> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<String>(versions);
    }

    public CopyPackageVersionsRequest withVersions(String ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<String>(versions.length));
        }
        for (String ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public CopyPackageVersionsRequest withVersions(Collection<String> versions) {
        this.setVersions(versions);
        return this;
    }

    public Map<String, String> getVersionRevisions() {
        return this.versionRevisions;
    }

    public void setVersionRevisions(Map<String, String> versionRevisions) {
        this.versionRevisions = versionRevisions;
    }

    public CopyPackageVersionsRequest withVersionRevisions(Map<String, String> versionRevisions) {
        this.setVersionRevisions(versionRevisions);
        return this;
    }

    public CopyPackageVersionsRequest addVersionRevisionsEntry(String key, String value) {
        if (null == this.versionRevisions) {
            this.versionRevisions = new HashMap<String, String>();
        }
        if (this.versionRevisions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.versionRevisions.put(key, value);
        return this;
    }

    public CopyPackageVersionsRequest clearVersionRevisionsEntries() {
        this.versionRevisions = null;
        return this;
    }

    public void setAllowOverwrite(Boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public Boolean getAllowOverwrite() {
        return this.allowOverwrite;
    }

    public CopyPackageVersionsRequest withAllowOverwrite(Boolean allowOverwrite) {
        this.setAllowOverwrite(allowOverwrite);
        return this;
    }

    public Boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public void setIncludeFromUpstream(Boolean includeFromUpstream) {
        this.includeFromUpstream = includeFromUpstream;
    }

    public Boolean getIncludeFromUpstream() {
        return this.includeFromUpstream;
    }

    public CopyPackageVersionsRequest withIncludeFromUpstream(Boolean includeFromUpstream) {
        this.setIncludeFromUpstream(includeFromUpstream);
        return this;
    }

    public Boolean isIncludeFromUpstream() {
        return this.includeFromUpstream;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getDomainOwner() != null) {
            sb.append("DomainOwner: ").append(this.getDomainOwner()).append(",");
        }
        if (this.getSourceRepository() != null) {
            sb.append("SourceRepository: ").append(this.getSourceRepository()).append(",");
        }
        if (this.getDestinationRepository() != null) {
            sb.append("DestinationRepository: ").append(this.getDestinationRepository()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackage() != null) {
            sb.append("Package: ").append(this.getPackage()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions()).append(",");
        }
        if (this.getVersionRevisions() != null) {
            sb.append("VersionRevisions: ").append(this.getVersionRevisions()).append(",");
        }
        if (this.getAllowOverwrite() != null) {
            sb.append("AllowOverwrite: ").append(this.getAllowOverwrite()).append(",");
        }
        if (this.getIncludeFromUpstream() != null) {
            sb.append("IncludeFromUpstream: ").append(this.getIncludeFromUpstream());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyPackageVersionsRequest)) {
            return false;
        }
        CopyPackageVersionsRequest other = (CopyPackageVersionsRequest)obj;
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getDomainOwner() == null ^ this.getDomainOwner() == null) {
            return false;
        }
        if (other.getDomainOwner() != null && !other.getDomainOwner().equals(this.getDomainOwner())) {
            return false;
        }
        if (other.getSourceRepository() == null ^ this.getSourceRepository() == null) {
            return false;
        }
        if (other.getSourceRepository() != null && !other.getSourceRepository().equals(this.getSourceRepository())) {
            return false;
        }
        if (other.getDestinationRepository() == null ^ this.getDestinationRepository() == null) {
            return false;
        }
        if (other.getDestinationRepository() != null && !other.getDestinationRepository().equals(this.getDestinationRepository())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackage() == null ^ this.getPackage() == null) {
            return false;
        }
        if (other.getPackage() != null && !other.getPackage().equals(this.getPackage())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.getVersionRevisions() == null ^ this.getVersionRevisions() == null) {
            return false;
        }
        if (other.getVersionRevisions() != null && !other.getVersionRevisions().equals(this.getVersionRevisions())) {
            return false;
        }
        if (other.getAllowOverwrite() == null ^ this.getAllowOverwrite() == null) {
            return false;
        }
        if (other.getAllowOverwrite() != null && !other.getAllowOverwrite().equals(this.getAllowOverwrite())) {
            return false;
        }
        if (other.getIncludeFromUpstream() == null ^ this.getIncludeFromUpstream() == null) {
            return false;
        }
        return other.getIncludeFromUpstream() == null || other.getIncludeFromUpstream().equals(this.getIncludeFromUpstream());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getDomainOwner() == null ? 0 : this.getDomainOwner().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRepository() == null ? 0 : this.getSourceRepository().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationRepository() == null ? 0 : this.getDestinationRepository().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackage() == null ? 0 : this.getPackage().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.getVersionRevisions() == null ? 0 : this.getVersionRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getAllowOverwrite() == null ? 0 : this.getAllowOverwrite().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeFromUpstream() == null ? 0 : this.getIncludeFromUpstream().hashCode());
        return hashCode;
    }

    public CopyPackageVersionsRequest clone() {
        return (CopyPackageVersionsRequest)super.clone();
    }
}

