/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ResourceDefinition;
import com.amazonaws.services.cloudformation.model.TemplateConfiguration;
import com.amazonaws.services.cloudformation.model.UpdateGeneratedTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class UpdateGeneratedTemplateRequestMarshaller
implements Marshaller<Request<UpdateGeneratedTemplateRequest>, UpdateGeneratedTemplateRequest> {
    public Request<UpdateGeneratedTemplateRequest> marshall(UpdateGeneratedTemplateRequest updateGeneratedTemplateRequest) {
        TemplateConfiguration templateConfiguration;
        if (updateGeneratedTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGeneratedTemplateRequest, "AmazonCloudFormation");
        request.addParameter("Action", "UpdateGeneratedTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateGeneratedTemplateRequest.getGeneratedTemplateName() != null) {
            request.addParameter("GeneratedTemplateName", StringUtils.fromString((String)updateGeneratedTemplateRequest.getGeneratedTemplateName()));
        }
        if (updateGeneratedTemplateRequest.getNewGeneratedTemplateName() != null) {
            request.addParameter("NewGeneratedTemplateName", StringUtils.fromString((String)updateGeneratedTemplateRequest.getNewGeneratedTemplateName()));
        }
        if (updateGeneratedTemplateRequest.getAddResources().isEmpty() && !((SdkInternalList)updateGeneratedTemplateRequest.getAddResources()).isAutoConstruct()) {
            request.addParameter("AddResources", "");
        }
        if (!updateGeneratedTemplateRequest.getAddResources().isEmpty() || !((SdkInternalList)updateGeneratedTemplateRequest.getAddResources()).isAutoConstruct()) {
            SdkInternalList addResourcesList = (SdkInternalList)updateGeneratedTemplateRequest.getAddResources();
            int addResourcesListIndex = 1;
            for (ResourceDefinition addResourcesListValue : addResourcesList) {
                if (addResourcesListValue != null) {
                    Map<String, String> resourceIdentifier;
                    if (addResourcesListValue.getResourceType() != null) {
                        request.addParameter("AddResources.member." + addResourcesListIndex + ".ResourceType", StringUtils.fromString((String)addResourcesListValue.getResourceType()));
                    }
                    if (addResourcesListValue.getLogicalResourceId() != null) {
                        request.addParameter("AddResources.member." + addResourcesListIndex + ".LogicalResourceId", StringUtils.fromString((String)addResourcesListValue.getLogicalResourceId()));
                    }
                    if ((resourceIdentifier = addResourcesListValue.getResourceIdentifier()) != null) {
                        int resourceIdentifierListIndex = 1;
                        for (Map.Entry<String, String> entry : resourceIdentifier.entrySet()) {
                            if (entry != null && entry.getKey() != null) {
                                request.addParameter("AddResources.member." + addResourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                            }
                            if (entry != null && entry.getValue() != null) {
                                request.addParameter("AddResources.member." + addResourcesListIndex + ".ResourceIdentifier.entry." + resourceIdentifierListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                            }
                            ++resourceIdentifierListIndex;
                        }
                    }
                }
                ++addResourcesListIndex;
            }
        }
        if (updateGeneratedTemplateRequest.getRemoveResources().isEmpty() && !((SdkInternalList)updateGeneratedTemplateRequest.getRemoveResources()).isAutoConstruct()) {
            request.addParameter("RemoveResources", "");
        }
        if (!updateGeneratedTemplateRequest.getRemoveResources().isEmpty() || !((SdkInternalList)updateGeneratedTemplateRequest.getRemoveResources()).isAutoConstruct()) {
            SdkInternalList removeResourcesList = (SdkInternalList)updateGeneratedTemplateRequest.getRemoveResources();
            int removeResourcesListIndex = 1;
            for (String removeResourcesListValue : removeResourcesList) {
                if (removeResourcesListValue != null) {
                    request.addParameter("RemoveResources.member." + removeResourcesListIndex, StringUtils.fromString((String)removeResourcesListValue));
                }
                ++removeResourcesListIndex;
            }
        }
        if (updateGeneratedTemplateRequest.getRefreshAllResources() != null) {
            request.addParameter("RefreshAllResources", StringUtils.fromBoolean((Boolean)updateGeneratedTemplateRequest.getRefreshAllResources()));
        }
        if ((templateConfiguration = updateGeneratedTemplateRequest.getTemplateConfiguration()) != null) {
            if (templateConfiguration.getDeletionPolicy() != null) {
                request.addParameter("TemplateConfiguration.DeletionPolicy", StringUtils.fromString((String)templateConfiguration.getDeletionPolicy()));
            }
            if (templateConfiguration.getUpdateReplacePolicy() != null) {
                request.addParameter("TemplateConfiguration.UpdateReplacePolicy", StringUtils.fromString((String)templateConfiguration.getUpdateReplacePolicy()));
            }
        }
        return request;
    }
}

