/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ScannedResourceIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListResourceScanRelatedResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceScanId;
    private SdkInternalList<ScannedResourceIdentifier> resources;
    private String nextToken;
    private Integer maxResults;

    public void setResourceScanId(String resourceScanId) {
        this.resourceScanId = resourceScanId;
    }

    public String getResourceScanId() {
        return this.resourceScanId;
    }

    public ListResourceScanRelatedResourcesRequest withResourceScanId(String resourceScanId) {
        this.setResourceScanId(resourceScanId);
        return this;
    }

    public List<ScannedResourceIdentifier> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<ScannedResourceIdentifier> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList(resources);
    }

    public ListResourceScanRelatedResourcesRequest withResources(ScannedResourceIdentifier ... resources) {
        if (this.resources == null) {
            this.setResources((Collection<ScannedResourceIdentifier>)new SdkInternalList(resources.length));
        }
        for (ScannedResourceIdentifier ele : resources) {
            this.resources.add((Object)ele);
        }
        return this;
    }

    public ListResourceScanRelatedResourcesRequest withResources(Collection<ScannedResourceIdentifier> resources) {
        this.setResources(resources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListResourceScanRelatedResourcesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListResourceScanRelatedResourcesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceScanId() != null) {
            sb.append("ResourceScanId: ").append(this.getResourceScanId()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanRelatedResourcesRequest)) {
            return false;
        }
        ListResourceScanRelatedResourcesRequest other = (ListResourceScanRelatedResourcesRequest)obj;
        if (other.getResourceScanId() == null ^ this.getResourceScanId() == null) {
            return false;
        }
        if (other.getResourceScanId() != null && !other.getResourceScanId().equals(this.getResourceScanId())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceScanId() == null ? 0 : this.getResourceScanId().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListResourceScanRelatedResourcesRequest clone() {
        return (ListResourceScanRelatedResourcesRequest)super.clone();
    }
}

