/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>AWS Auto Scaling</fullname>
 * <p>
 * Use AWS Auto Scaling to create scaling plans for your applications to automatically scale your scalable AWS
 * resources.
 * </p>
 * <p>
 * <b>API Summary</b>
 * </p>
 * <p>
 * You can use the AWS Auto Scaling service API to accomplish the following tasks:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Create and manage scaling plans
 * </p>
 * </li>
 * <li>
 * <p>
 * Define target tracking scaling policies to dynamically scale your resources based on utilization
 * </p>
 * </li>
 * <li>
 * <p>
 * Scale Amazon EC2 Auto Scaling groups using predictive scaling and dynamic scaling to scale your Amazon EC2 capacity
 * faster
 * </p>
 * </li>
 * <li>
 * <p>
 * Set minimum and maximum capacity limits
 * </p>
 * </li>
 * <li>
 * <p>
 * Retrieve information on existing scaling plans
 * </p>
 * </li>
 * <li>
 * <p>
 * Access current forecast data and historical forecast data for up to 56 days previous
 * </p>
 * </li>
 * </ul>
 * <p>
 * To learn more about AWS Auto Scaling, including information about granting IAM users required permissions for AWS
 * Auto Scaling actions, see the <a
 * href="https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html">AWS Auto Scaling User
 * Guide</a>.
 * </p>
 */
package com.amazonaws.services.autoscalingplans;

